/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.keys.GroupCacheKey;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.httpcache.util.UserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Extension - Group", description="HttpCacheConfig custom extension for group based configuration and associated cache key creation (HttpCacheConfig and CacheKeyFactory).", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Allowed user groups: [ {httpcache.config.extension.user-groups.allowed} ] Config name: [ config.name ]"}), @Property(name="service.ranking", intValue={70})})
@Service
public class GroupHttpCacheConfigExtension
implements HttpCacheConfigExtension,
CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(GroupHttpCacheConfigExtension.class);
    @Property(label="Allowed user groups", description="Users groups that are used to accept and create cache keys.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_USER_GROUPS = "httpcache.config.extension.user-groups.allowed";
    @Property(label="Config Name")
    private static final String PROP_CONFIG_NAME = "config.name";
    private List<String> userGroups;

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        if (UserUtils.isAnonymous(request.getResourceResolver().getUserID())) {
            return true;
        }
        if (this.userGroups.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("GroupHttpCacheConfigExtension accepts request [ {} ]", (Object)request.getRequestURI());
            }
            return true;
        }
        try {
            List<String> requestUserGroupNames = UserUtils.getUserGroupMembershipNames((User)request.getResourceResolver().adaptTo(User.class));
            boolean isGroupMatchFound = CollectionUtils.containsAny(this.userGroups, requestUserGroupNames);
            if (!isGroupMatchFound) {
                log.trace("Group didn't match and hence rejecting the cache config.");
            } else if (log.isTraceEnabled()) {
                log.trace("GroupHttpCacheConfigExtension accepts request [ {} ]", (Object)request.getRequestURI());
            }
            return isGroupMatchFound;
        }
        catch (RepositoryException e) {
            throw new HttpCacheRepositoryAccessException("Unable to access group information of request user.", e);
        }
    }

    @Override
    public CacheKey build(SlingHttpServletRequest slingHttpServletRequest, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new GroupCacheKey(slingHttpServletRequest, cacheConfig, this.userGroups);
    }

    @Override
    public CacheKey build(String resourcePath, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new GroupCacheKey(resourcePath, cacheConfig, this.userGroups);
    }

    @Override
    public boolean doesKeyMatchConfig(CacheKey key, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        if (!(key instanceof GroupCacheKey)) {
            return false;
        }
        return new GroupCacheKey(key.getUri(), cacheConfig, this.userGroups).equals(key);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> configs) {
        this.userGroups = new ArrayList<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_USER_GROUPS), (String[])new String[0])));
        ListIterator<String> listIterator = this.userGroups.listIterator();
        while (listIterator.hasNext()) {
            String value = listIterator.next();
            if (!StringUtils.isBlank((String)value)) continue;
            listIterator.remove();
        }
        log.info("GroupHttpCacheConfigExtension activated/modified.");
    }
}

