/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.impl.keys.CombinedCacheKey;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CacheKeyFactory.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.ranking:Integer=2147483647", "webconsole.configurationFactory.nameHint=Config name: [ config.name ]"}, reference={@Reference(name="cacheKeyFactories", bind="bindCacheKeyFactory", unbind="unbindCacheKeyFactory", service=CacheKeyFactory.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)})
@Designate(ocd=Config.class, factory=true)
public class CombinedCacheKeyFactory
implements CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(CombinedCacheKeyFactory.class);
    private String configName;
    private RankedServices<CacheKeyFactory> cacheKeyFactories = new RankedServices(Order.ASCENDING);

    @Override
    public CacheKey build(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new CombinedCacheKey(request, cacheConfig, (List<CacheKeyFactory>)this.cacheKeyFactories.getList());
    }

    @Override
    public CacheKey build(String resourcePath, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new CombinedCacheKey(resourcePath, cacheConfig, (List<CacheKeyFactory>)this.cacheKeyFactories.getList());
    }

    @Override
    public boolean doesKeyMatchConfig(CacheKey key, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        if (!(key instanceof CombinedCacheKey)) {
            return false;
        }
        return new CombinedCacheKey(key.getUri(), cacheConfig, (List<CacheKeyFactory>)this.cacheKeyFactories.getList()).equals(key);
    }

    protected void bindCacheKeyFactory(CacheKeyFactory factory, Map<String, Object> properties) {
        if (factory != this) {
            this.cacheKeyFactories.bind((Object)factory, properties);
        } else {
            log.error("Invalid key factory LDAP target string! Self is target(ed)! Breaking up infinite loop. Configname: {}", (Object)this.configName);
        }
    }

    protected void unbindCacheKeyFactory(CacheKeyFactory factory, Map<String, Object> properties) {
        if (factory != this) {
            this.cacheKeyFactories.unbind((Object)factory, properties);
        }
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.configName = config.config_name();
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - CacheKeyFactory Combiner", description="Aggregates multiple extensions into a single cache key")
    public static @interface Config {
        @AttributeDefinition(name="Config Name")
        public String config_name() default "";

        @AttributeDefinition(name="CacheKey factory service PIDs", description="Service PID(s) of target implementation of CacheKeyFactory to be used.")
        public String cacheKeyFactories_target();
    }
}

