/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.auth.saml.impl;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Component(label="ACS AEM Commons - Okta Logout Handler", description="Specific Authentication Handler to handle logout to Okta SSO Provider which, in some configurations, does not support traditional Single Logout", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="service.description", value={"ACS AEM Commons Okta Logout Handler"}, propertyPrivate=true), @Property(name="service.ranking", intValue={5003}, propertyPrivate=false), @Property(name="path", value={"/"}, propertyPrivate=false)})
public class OktaLogoutHandler
implements AuthenticationHandler {
    @Property
    private static final String PROP_OKTA_HOST_NAME = "okta.host.name";
    @Property
    private static final String PROP_FROM_URI = "from.uri";
    private String redirectLocation;

    @Activate
    protected void activate(Map<String, Object> props) {
        String oktaHostName = PropertiesUtil.toString((Object)props.get(PROP_OKTA_HOST_NAME), null);
        if (oktaHostName == null) {
            throw new IllegalArgumentException("Okta Host Name must be provided");
        }
        String fromUri = PropertiesUtil.toString((Object)props.get(PROP_FROM_URI), null);
        StringBuilder builder = new StringBuilder("https://");
        builder.append(oktaHostName);
        builder.append("/login/signout");
        if (fromUri != null) {
            builder.append("?fromURI=").append(fromUri);
        }
        this.redirectLocation = builder.toString();
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return false;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.redirectLocation);
    }
}

