/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.util.QueryHelper;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.SubStatus;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.day.cq.workflow.WorkflowException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class FastActionManagerRunnerImpl
extends AbstractWorkflowRunner
implements BulkWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(FastActionManagerRunnerImpl.class);
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;
    @Reference
    private ResourceResolverFactory resourceResolverFactoryRef;
    @Reference
    private QueryHelper queryHelperRef;
    @Reference
    private ActionManagerFactory actionManagerFactoryRef;
    @Reference
    private SyntheticWorkflowRunner syntheticWorkflowRunnerRef;

    @Override
    public final Runnable getRunnable(Config config) {
        return new FastActionManagerRunnable(config, this.resourceResolverFactoryRef, this.queryHelperRef, this.actionManagerFactoryRef, this.syntheticWorkflowRunnerRef);
    }

    @Override
    public ScheduleOptions getOptions(Config config) {
        return null;
    }

    @Override
    public void initialize(QueryHelper queryHelper, Config config) throws PersistenceException, RepositoryException {
        Workspace workspace = config.getWorkspace();
        this.initialize(workspace, 0);
        workspace.commit();
    }

    @Override
    public void start(Workspace workspace) throws PersistenceException {
        if (!this.throttledTaskRunner.isRunning()) {
            this.throttledTaskRunner.resumeExecution();
        }
        super.start(workspace);
    }

    @Override
    public void stopping(Workspace workspace) throws PersistenceException {
        this.stop(workspace);
    }

    @Override
    public void stop(Workspace workspace) throws PersistenceException {
        this.throttledTaskRunner.pauseExecution();
        super.stop(workspace);
    }

    @Override
    public void stop(Workspace workspace, SubStatus subStatus) throws PersistenceException {
        this.throttledTaskRunner.pauseExecution();
        super.stop(workspace, subStatus);
    }

    @Override
    public void stopWithError(Workspace workspace) throws PersistenceException {
        this.throttledTaskRunner.pauseExecution();
        super.stopWithError(workspace);
    }

    public void complete(ResourceResolver resourceResolver, String workspacePath, ActionManager manager, int success) throws PersistenceException, RepositoryException {
        Workspace workspace = (Workspace)resourceResolver.getResource(workspacePath).adaptTo(Workspace.class);
        workspace.setCompleteCount(success);
        for (Failure f : manager.getFailureList()) {
            workspace.addFailure(f.getNodePath(), null, f.getTime());
            workspace.incrementFailCount();
        }
        super.complete(workspace);
        manager.closeAllResolvers();
        if (this.actionManagerFactoryRef != null) {
            this.actionManagerFactoryRef.purgeCompletedTasks();
        } else {
            log.warn("Action Manager Factory reference is null. Please purge completed tasks via the JMX console.");
        }
    }

    @Override
    public void complete(Workspace workspace, Payload payload) throws Exception {
        throw new UnsupportedOperationException("FAM payloads cannot be completed as they are not tracked");
    }

    @Override
    public void run(Workspace workspace, Payload payload) {
        if (!this.throttledTaskRunner.isRunning()) {
            this.throttledTaskRunner.resumeExecution();
        }
    }

    @Override
    public void forceTerminate(Workspace workspace, Payload payload) throws Exception {
        throw new UnsupportedOperationException("FAM jobs cannot be force terminated");
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }

    protected void bindResourceResolverFactoryRef(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactoryRef = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactoryRef(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactoryRef == resourceResolverFactory) {
            this.resourceResolverFactoryRef = null;
        }
    }

    protected void bindQueryHelperRef(QueryHelper queryHelper) {
        this.queryHelperRef = queryHelper;
    }

    protected void unbindQueryHelperRef(QueryHelper queryHelper) {
        if (this.queryHelperRef == queryHelper) {
            this.queryHelperRef = null;
        }
    }

    protected void bindActionManagerFactoryRef(ActionManagerFactory actionManagerFactory) {
        this.actionManagerFactoryRef = actionManagerFactory;
    }

    protected void unbindActionManagerFactoryRef(ActionManagerFactory actionManagerFactory) {
        if (this.actionManagerFactoryRef == actionManagerFactory) {
            this.actionManagerFactoryRef = null;
        }
    }

    protected void bindSyntheticWorkflowRunnerRef(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        this.syntheticWorkflowRunnerRef = syntheticWorkflowRunner;
    }

    protected void unbindSyntheticWorkflowRunnerRef(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        if (this.syntheticWorkflowRunnerRef == syntheticWorkflowRunner) {
            this.syntheticWorkflowRunnerRef = null;
        }
    }

    private class FastActionManagerRunnable
    implements Runnable {
        private final String configPath;
        private final ResourceResolverFactory resourceResolverFactory;
        private final QueryHelper queryHelper;
        private final ActionManagerFactory actionManagerFactory;
        private final SyntheticWorkflowRunner syntheticWorkflowRunner;

        public FastActionManagerRunnable(Config config, ResourceResolverFactory resourceResolverFactory, QueryHelper queryHelper, ActionManagerFactory actionManagerFactory, SyntheticWorkflowRunner syntheticWorkflowRunner) {
            this.configPath = config.getPath();
            this.resourceResolverFactory = resourceResolverFactory;
            this.queryHelper = queryHelper;
            this.actionManagerFactory = actionManagerFactory;
            this.syntheticWorkflowRunner = syntheticWorkflowRunner;
        }

        @Override
        public void run() {
            try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AbstractWorkflowRunner.AUTH_INFO);){
                Resource configResource = resourceResolver.getResource(this.configPath);
                Config config = (Config)configResource.adaptTo(Config.class);
                Workspace workspace = config.getWorkspace();
                if (StringUtils.isNotBlank((String)workspace.getActionManagerName()) && this.actionManagerFactory.hasActionManager(workspace.getActionManagerName())) {
                    log.warn("Action Manager already exists for [ {} ]", (Object)workspace.getActionManagerName());
                    return;
                }
                if (config.isUserEventData()) {
                    ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(config.getUserEventData());
                }
                List<Resource> resources = this.queryHelper.findResources(resourceResolver, config.getQueryType(), config.getQueryStatement(), config.getRelativePath());
                this.actionManagerFactory.purgeCompletedTasks();
                ActionManager manager = this.actionManagerFactory.createTaskManager("Bulk Workflow Manager @ " + config.getPath(), resourceResolver, config.getBatchSize());
                SyntheticWorkflowModel model = this.syntheticWorkflowRunner.getSyntheticWorkflowModel(resourceResolver, config.getWorkflowModelId(), true);
                workspace.setTotalCount(resources.size());
                workspace.setActionManagerName(manager.getName());
                workspace.commit();
                String workspacePath = workspace.getPath();
                int retryCount = config.getRetryCount();
                int retryPause = config.getInterval();
                AtomicInteger processed = new AtomicInteger(0);
                int total = resources.size();
                AtomicInteger success = new AtomicInteger(0);
                resources.stream().map(resource -> resource.getPath()).forEach(path -> manager.deferredWithResolver(r -> {
                    block9: {
                        try {
                            manager.setCurrentItem((String)path);
                            if (retryCount > 0) {
                                try {
                                    Actions.retryAll(retryCount, retryPause, Actions.startSyntheticWorkflows(model, this.syntheticWorkflowRunner)).accept((ResourceResolver)r, (String)path);
                                    success.incrementAndGet();
                                    break block9;
                                }
                                catch (Exception e) {
                                    log.warn("Could not process [ {} ] with [ " + retryCount + " ] retries", path, (Object)e);
                                    throw e;
                                }
                            }
                            try {
                                Actions.startSyntheticWorkflows(model, this.syntheticWorkflowRunner).accept((ResourceResolver)r, (String)path);
                                success.incrementAndGet();
                            }
                            catch (Exception e) {
                                log.warn("Could not process [ {} ]", path, (Object)e);
                                throw e;
                            }
                        }
                        finally {
                            if (processed.incrementAndGet() == total) {
                                FastActionManagerRunnerImpl.this.complete((ResourceResolver)r, workspacePath, manager, success.get());
                            }
                        }
                    }
                }));
            }
            catch (WorkflowException | RepositoryException | LoginException | PersistenceException e) {
                log.error("Error occurred while processing Fast Action Manager Synthetic Workflow via Bulk Workflow Manager", e);
            }
        }
    }
}

