/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.tagging.TagManager;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PropertyMergePostProcessor
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropertyMergePostProcessor.class);
    private static final String AT_SUFFIX = "@PropertyMerge";
    private static final String ALLOW_DUPLICATES_SUFFIX = "@PropertyMerge.AllowDuplicates";
    private static final String TYPE_HINT_SUFFIX = "@PropertyMerge.TypeHint";
    private static final String IGNORE_PREFIX = ":";
    protected static final String OPERATION_ALL_TAGS = "Operation.mergeAllTags";
    private static final String VALID_JCR_NAME = "[^:/\\[\\]\\|\\s*]+";
    private static final Pattern VALID_TAG = Pattern.compile("^[^:/\\[\\]\\|\\s*]+:([^:/\\[\\]\\|\\s*]+/)*([^:/\\[\\]\\|\\s*]+)?$");

    public final void process(SlingHttpServletRequest request, List<Modification> modifications) throws Exception {
        List<PropertyMerge> propertyMerges = this.getPropertyMerges(request);
        Resource resource = request.getResource();
        for (PropertyMerge propertyMerge : propertyMerges) {
            this.merge(resource, propertyMerge.getDestination(), propertyMerge.getSources(), propertyMerge.getTypeHint(), propertyMerge.isAllowDuplicates()).ifPresent(modifiedResource -> {
                modifications.add(Modification.onModified((String)modifiedResource.getPath()));
                log.debug("Merged property values from {} into [ {} ]", propertyMerge.getSources(), (Object)propertyMerge.getDestination());
            });
        }
    }

    private List<PropertyMerge> getPropertyMerges(SlingHttpServletRequest request) {
        RequestParameterMap requestParameters = request.getRequestParameterMap();
        HashMap mapping = new HashMap();
        boolean isBulkUpdate = Boolean.valueOf(PropertyMergePostProcessor.getParamValue(requestParameters, "dam:bulkUpdate"));
        requestParameters.forEach((key, values) -> {
            if (!StringUtils.endsWith((String)key, (String)AT_SUFFIX)) {
                return;
            }
            Function<String, String> stripPrefix = s -> StringUtils.removeStart((String)StringUtils.stripToNull((String)s), (String)IGNORE_PREFIX);
            String source = stripPrefix.apply(StringUtils.substringBefore((String)key, (String)AT_SUFFIX));
            Stream.of(values).map(RequestParameter::getString).map(stripPrefix).filter(Objects::nonNull).forEach(destination -> {
                if (source.equalsIgnoreCase(OPERATION_ALL_TAGS)) {
                    this.trackAllTagsMergeParameters(request, (String)destination, mapping);
                } else if (isBulkUpdate) {
                    this.trackAssetMergeParameters(requestParameters, source, (String)destination, mapping);
                } else {
                    this.trackMergeParameters(mapping, source, (String)destination);
                }
            });
        });
        return mapping.entrySet().stream().map(entry -> new PropertyMerge((String)entry.getKey(), (Collection)entry.getValue(), PropertyMergePostProcessor.areDuplicatesAllowed(requestParameters, (String)entry.getKey()), PropertyMergePostProcessor.getFieldTypeHint(requestParameters, (String)entry.getKey()))).collect(Collectors.toList());
    }

    private void trackMergeParameters(HashMap<String, Set<String>> mapping, String source, String destination) {
        mapping.merge(destination, new HashSet(), (a, b) -> a).add(source);
    }

    private void trackAssetMergeParameters(RequestParameterMap requestParameters, String source, String destination, HashMap<String, Set<String>> mapping) {
        requestParameters.keySet().stream().map(String::valueOf).filter(paramName -> paramName.endsWith("/" + source)).forEach(adjustedSource -> {
            String adjustedDest = PropertyMergePostProcessor.alignDestinationPath(adjustedSource, destination);
            this.trackMergeParameters(mapping, (String)adjustedSource, adjustedDest);
        });
    }

    private void trackAllTagsMergeParameters(SlingHttpServletRequest request, String destination, HashMap<String, Set<String>> mapping) {
        request.getRequestParameterMap().forEach((source, value) -> {
            if (PropertyMergePostProcessor.hasTags(request.getResourceResolver(), value)) {
                String newDestination = PropertyMergePostProcessor.alignDestinationPath(source, destination);
                this.trackMergeParameters(mapping, (String)source, newDestination);
            }
        });
    }

    protected static boolean hasTags(ResourceResolver rr, RequestParameter[] params) {
        if (params == null) {
            return false;
        }
        TagManager tagManager = (TagManager)rr.adaptTo(TagManager.class);
        return Stream.of(params).allMatch(param -> PropertyMergePostProcessor.looksLikeTag(param.getString()) && tagManager.resolve(param.getString()) != null);
    }

    protected static boolean looksLikeTag(String value) {
        return VALID_TAG.asPredicate().test(value);
    }

    protected static boolean areDuplicatesAllowed(RequestParameterMap params, String field) {
        return Boolean.valueOf(PropertyMergePostProcessor.getParamValue(params, IGNORE_PREFIX + field + ALLOW_DUPLICATES_SUFFIX));
    }

    protected static String getFieldTypeHint(RequestParameterMap params, String field) {
        return StringUtils.defaultString((String)PropertyMergePostProcessor.getParamValue(params, IGNORE_PREFIX + field + TYPE_HINT_SUFFIX), (String)String.class.getSimpleName());
    }

    protected static String alignDestinationPath(String source, String destination) {
        if (source.contains("jcr:content")) {
            return StringUtils.substringBeforeLast((String)source, (String)"jcr:content") + destination;
        }
        return destination;
    }

    protected static String getParamValue(RequestParameterMap params, String paramName) {
        RequestParameter param = params.getValue(paramName);
        return param == null ? null : param.getString();
    }

    protected final <T> Optional<Resource> merge(Resource resource, String destination, Collection<String> sources, Class<T> typeHint, boolean allowDuplicates) throws PersistenceException {
        ModifiableValueMap targetProperties;
        Object[] currentValues;
        ResourceResolver rr = resource.getResourceResolver();
        Object[] emptyArray = (Object[])Array.newInstance(typeHint, 0);
        AbstractCollection collectedValues = allowDuplicates ? new ArrayList() : new LinkedHashSet();
        for (String source : sources) {
            Resource sourceProperties = resource;
            String sourceParam = source;
            if (source.contains("/")) {
                sourceParam = StringUtils.substringAfterLast((String)source, (String)"/");
                sourceProperties = rr.getResource(resource, StringUtils.substringBeforeLast((String)source, (String)"/"));
            }
            Object[] tmp = (Object[])((ModifiableValueMap)sourceProperties.adaptTo(ModifiableValueMap.class)).get(sourceParam, (Object)emptyArray);
            collectedValues.addAll(Arrays.asList(tmp));
        }
        Resource targetResource = resource;
        String targetProperty = destination;
        if (destination.contains("/")) {
            targetProperty = StringUtils.substringAfterLast((String)destination, (String)"/");
            targetResource = rr.getResource(resource, StringUtils.substringBeforeLast((String)destination, (String)"/"));
        }
        if (!collectedValues.equals(Arrays.asList(currentValues = (Object[])(targetProperties = (ModifiableValueMap)targetResource.adaptTo(ModifiableValueMap.class)).get(targetProperty, (Object)emptyArray)))) {
            targetProperties.put((Object)targetProperty, (Object)collectedValues.toArray(emptyArray));
            return Optional.of(targetResource);
        }
        return Optional.empty();
    }

    private static class PropertyMerge {
        private boolean allowDuplicates;
        private Class<?> typeHint;
        private String destination;
        private Collection<String> sources;

        public PropertyMerge(String destination, Collection<String> sources, boolean allowDuplicates, String typeHint) {
            this.destination = destination;
            this.sources = Optional.ofNullable(sources).map(coll -> new HashSet(coll)).orElse(Collections.emptySet());
            this.allowDuplicates = allowDuplicates;
            this.typeHint = this.convertTypeHint(typeHint);
        }

        private Class<?> convertTypeHint(String typeHintStr) {
            if (Boolean.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Boolean.class;
            }
            if (Double.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Double.class;
            }
            if (Long.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Long.class;
            }
            if (Date.class.getSimpleName().equalsIgnoreCase(typeHintStr) || Calendar.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Calendar.class;
            }
            return String.class;
        }

        public boolean isAllowDuplicates() {
            return this.allowDuplicates;
        }

        public Class<?> getTypeHint() {
            return this.typeHint;
        }

        public String getDestination() {
            return this.destination;
        }

        public Collection<String> getSources() {
            return Collections.unmodifiableCollection(this.sources);
        }
    }
}

