/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.util.ModeUtil;
import com.adobe.acs.commons.util.ResourceDataUtil;
import com.adobe.acs.commons.wcm.ComponentErrorHandler;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Component-Level Error Handler", description="Handles errors at the component level. Allows different HTML renditions to display for erring components based on WCM Mode collections (Edit, Preview, Publish).", policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="sling.filter.scope", value={"component"}, propertyPrivate=true), @Property(name="filter.order", intValue={1000000}, propertyPrivate=true)})
@Service
public class ComponentErrorHandlerImpl
implements ComponentErrorHandler,
Filter {
    private static final Logger log = LoggerFactory.getLogger((String)ComponentErrorHandlerImpl.class.getName());
    static final int FILTER_ORDER = 1000000;
    static final String BLANK_HTML = "/dev/null";
    static final String REQ_ATTR_PREVIOUSLY_PROCESSED = ComponentErrorHandlerImpl.class.getName() + "_previouslyProcessed";
    private static final String SERVICE_NAME = "component-error-handler";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "component-error-handler");
    private static final String DISABLED = "Disabled";
    private static final String ENABLED = "Enabled";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private static final boolean DEFAULT_EDIT_ENABLED = true;
    private boolean editModeEnabled = true;
    @Property(label="Edit Error Handling", description="Enable handling of Edit-mode errors (EDIT, DESIGN, ANALYTICS)", boolValue={true})
    public static final String PROP_EDIT_ENABLED = "edit.enabled";
    private static final String DEFAULT_EDIT_ERROR_HTML_PATH = "/apps/acs-commons/components/utilities/component-error-handler/edit.html";
    private String editErrorHTMLPath = "/apps/acs-commons/components/utilities/component-error-handler/edit.html";
    @Property(label="Edit HTML Error Path", description="Path to html file in JCR use to display an erring component in EDIT or DESIGN modes.", value={"/apps/acs-commons/components/utilities/component-error-handler/edit.html"})
    public static final String PROP_EDIT_ERROR_HTML_PATH = "edit.html";
    private static final boolean DEFAULT_PREVIEW_ENABLED = false;
    private boolean previewModeEnabled = false;
    @Property(label="Preview Error Handling", description="Enable handling of Edit-mode errors (PREVIEW and READ_ONLY)", boolValue={false})
    public static final String PROP_PREVIEW_ENABLED = "preview.enabled";
    private static final String DEFAULT_PREVIEW_ERROR_HTML_PATH = "/apps/acs-commons/components/utilities/component-error-handler/preview.html";
    private String previewErrorHTMLPath = "/apps/acs-commons/components/utilities/component-error-handler/preview.html";
    @Property(label="Preview HTML Error Path", description="Path to html file in JCR use to display an erring component in PREVIEW or READONLY modes.", value={"/apps/acs-commons/components/utilities/component-error-handler/preview.html"})
    public static final String PROP_PREVIEW_ERROR_HTML_PATH = "preview.html";
    private static final boolean DEFAULT_PUBLISH_ENABLED = false;
    private boolean publishModeEnabled = false;
    @Property(label="Publish Error Handling", description="Enable handling of Edit-mode errors (PREVIEW and READONLY)", boolValue={false})
    public static final String PROP_PUBLISH_ENABLED = "publish.enabled";
    private static final String DEFAULT_PUBLISH_ERROR_HTML_PATH = "/dev/null";
    private String publishErrorHTMLPath = "/dev/null";
    @Property(label="Publish HTML Error Path", description="Path to html file in JCR use to display an erring component in DISABLED mode.", value={"/dev/null"})
    public static final String PROP_PUBLISH_ERROR_HTML_PATH = "publish.html";
    private static final String[] DEFAULT_SUPPRESSED_RESOURCE_TYPES = new String[0];
    private String[] suppressedResourceTypes = DEFAULT_SUPPRESSED_RESOURCE_TYPES;
    @Property(label="Suppressed Resource Types", description="Resource types this Filter will ignore during Sling Includes.", cardinality=0x7FFFFFFF, value={})
    public static final String PROP_SUPPRESSED_RESOURCE_TYPES = "suppress-resource-types";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)servletRequest;
        SlingHttpServletResponse response = (SlingHttpServletResponse)servletResponse;
        if (!this.accepts(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SlingHttpServletRequest slingRequest = request;
        SlingHttpServletResponse slingResponse = response;
        if (this.editModeEnabled && (ModeUtil.isEdit(request) || ModeUtil.isDesign(request) || ModeUtil.isAnalytics(slingRequest))) {
            this.doFilterWithErrorHandling(slingRequest, slingResponse, chain, this.editErrorHTMLPath);
        } else if (this.previewModeEnabled && (ModeUtil.isPreview(request) || ModeUtil.isReadOnly(request))) {
            this.doFilterWithErrorHandling(slingRequest, slingResponse, chain, this.previewErrorHTMLPath);
        } else if (this.publishModeEnabled && ModeUtil.isDisabled(request) && !this.isFirstInChain(slingRequest)) {
            this.doFilterWithErrorHandling(slingRequest, slingResponse, chain, this.publishErrorHTMLPath);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterWithErrorHandling(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, FilterChain chain, String pathToHTML) throws ServletException, IOException {
        boolean suppress = this.isComponentErrorHandlingSuppressed((ServletRequest)slingRequest);
        if (suppress) {
            log.debug("Suppressing component error handling for: {}", (Object)slingRequest.getResource().getPath());
        }
        try {
            chain.doFilter((ServletRequest)slingRequest, (ServletResponse)slingResponse);
        }
        catch (Exception ex) {
            if (this.isComponentErrorHandlingSuppressed((ServletRequest)slingRequest)) {
                log.debug("Suppressed component error handling for: {}", (Object)slingRequest.getResource().getPath());
                throw new ServletException((Throwable)ex);
            }
            this.handleError(slingResponse, slingRequest.getResource(), pathToHTML, ex);
        }
        finally {
            if (suppress) {
                this.suppressComponentErrorHandling(slingRequest);
            } else if (this.isComponentErrorHandlingSuppressed((ServletRequest)slingRequest)) {
                log.debug("Removing suppression component error handling at: {}", (Object)slingRequest.getResource().getPath());
                this.allowComponentErrorHandling(slingRequest);
            }
        }
    }

    private void handleError(SlingHttpServletResponse slingResponse, Resource resource, String pathToHTML, Throwable ex) throws IOException {
        log.error(ex.getMessage(), ex);
        this.writeErrorHTML(slingResponse, resource, pathToHTML);
    }

    private void writeErrorHTML(SlingHttpServletResponse slingResponse, Resource resource, String pathToHTML) throws IOException {
        log.info("ACS AEM Commons Component-Level Error Handling trapped error for: {}", (Object)resource.getPath());
        slingResponse.getWriter().print(this.getHTML(pathToHTML));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHTML(String path) {
        if (StringUtils.isBlank((String)path)) return "";
        if (StringUtils.equals((String)"/dev/null", (String)path)) {
            return "";
        }
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            String string = ResourceDataUtil.getNTFileAsString(path, resourceResolver);
            return string;
        }
        catch (Exception e) {
            log.error("Could not get the component error HTML at [ {} ], using blank.", (Object)path);
            return "";
        }
    }

    protected final boolean accepts(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (!StringUtils.endsWith((String)request.getRequestURI(), (String)".html") || !StringUtils.contains((String)response.getContentType(), (String)"html")) {
            return false;
        }
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)request);
        if (componentContext == null || componentContext.getComponent() == null || componentContext.isRoot()) {
            return false;
        }
        if (this.isComponentErrorHandlingSuppressed((ServletRequest)request)) {
            return false;
        }
        SlingHttpServletRequest slingRequest = request;
        for (String suppressedResourceType : this.suppressedResourceTypes) {
            if (!slingRequest.getResource().isResourceType(suppressedResourceType)) continue;
            return false;
        }
        return true;
    }

    private boolean isFirstInChain(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR_PREVIOUSLY_PROCESSED) != null) {
            return false;
        }
        request.setAttribute(REQ_ATTR_PREVIOUSLY_PROCESSED, (Object)true);
        return true;
    }

    public final void destroy() {
        this.editModeEnabled = false;
        this.previewModeEnabled = false;
        this.publishModeEnabled = false;
    }

    @Activate
    public final void activate(Map<String, String> config) {
        String legacyPrefix = "prop.";
        this.editModeEnabled = PropertiesUtil.toBoolean((Object)config.get(PROP_EDIT_ENABLED), (boolean)PropertiesUtil.toBoolean((Object)config.get("prop.edit.enabled"), (boolean)true));
        this.previewModeEnabled = PropertiesUtil.toBoolean((Object)config.get(PROP_PREVIEW_ENABLED), (boolean)PropertiesUtil.toBoolean((Object)config.get("prop.preview.enabled"), (boolean)false));
        this.publishModeEnabled = PropertiesUtil.toBoolean((Object)config.get(PROP_PUBLISH_ENABLED), (boolean)PropertiesUtil.toBoolean((Object)config.get("prop.publish.enabled"), (boolean)false));
        this.editErrorHTMLPath = PropertiesUtil.toString((Object)config.get(PROP_EDIT_ERROR_HTML_PATH), (String)PropertiesUtil.toString((Object)config.get("prop.edit.html"), (String)DEFAULT_EDIT_ERROR_HTML_PATH));
        this.previewErrorHTMLPath = PropertiesUtil.toString((Object)config.get(PROP_PREVIEW_ERROR_HTML_PATH), (String)PropertiesUtil.toString((Object)config.get("prop.preview.html"), (String)DEFAULT_PREVIEW_ERROR_HTML_PATH));
        this.publishErrorHTMLPath = PropertiesUtil.toString((Object)config.get(PROP_PUBLISH_ERROR_HTML_PATH), (String)PropertiesUtil.toString((Object)config.get("prop.publish.html"), (String)"/dev/null"));
        log.info("Component Error Handling for Edit Modes: {} ~> {}", (Object)(this.editModeEnabled ? ENABLED : DISABLED), (Object)this.editErrorHTMLPath);
        log.info("Component Error Handling for Preview Modes: {} ~> {}", (Object)(this.previewModeEnabled ? ENABLED : DISABLED), (Object)this.previewErrorHTMLPath);
        log.info("Component Error Handling for Publish Modes: {} ~> {}", (Object)(this.publishModeEnabled ? ENABLED : DISABLED), (Object)this.publishErrorHTMLPath);
        this.suppressedResourceTypes = PropertiesUtil.toStringArray((Object)config.get(PROP_SUPPRESSED_RESOURCE_TYPES), (String[])DEFAULT_SUPPRESSED_RESOURCE_TYPES);
        log.info("Suppressed Resource Types: {}", (Object)Arrays.toString(this.suppressedResourceTypes));
    }

    @Override
    public final void suppressComponentErrorHandling(SlingHttpServletRequest request) {
        request.setAttribute("com.adobe.acs.commons.wcm.component-error-handler.suppress", (Object)true);
    }

    @Override
    public final void allowComponentErrorHandling(SlingHttpServletRequest request) {
        request.removeAttribute("com.adobe.acs.commons.wcm.component-error-handler.suppress");
    }

    private boolean isComponentErrorHandlingSuppressed(ServletRequest request) {
        Boolean suppress = (Boolean)request.getAttribute("com.adobe.acs.commons.wcm.component-error-handler.suppress");
        if (suppress != null) {
            return suppress;
        }
        return false;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

