/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.commons.inherit.InheritanceValueMap;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMapTypeConverter {
    private final String name;
    private final Type declaredType;
    private final Object convertedValue;
    private ValueMap valueMap;
    private InheritanceValueMap inheritanceValueMap;
    private static final Logger LOG = LoggerFactory.getLogger(ValueMapTypeConverter.class);

    public ValueMapTypeConverter(InheritanceValueMap inheritanceValueMap, String name, Type declaredType) {
        this.inheritanceValueMap = inheritanceValueMap;
        this.name = name;
        this.declaredType = declaredType;
        this.convertedValue = this.convertValue();
    }

    public ValueMapTypeConverter(ValueMap valueMap, String name, Type declaredType) {
        this.valueMap = valueMap;
        this.name = name;
        this.declaredType = declaredType;
        this.convertedValue = this.convertValue();
    }

    private Object convertValue() {
        if (this.declaredType instanceof Class) {
            try {
                Class clazz = (Class)this.declaredType;
                if (clazz.isArray()) {
                    return this.handleArrayProperty(clazz);
                }
                return this.getValueFromMap(clazz);
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        if (ParameterizedType.class.isInstance(this.declaredType)) {
            return this.handleCollectionTypes((ParameterizedType)this.declaredType);
        }
        LOG.debug("ValueMapTypeConverter doesn't support non-class types {}", (Object)this.declaredType);
        return null;
    }

    private Object handleCollectionTypes(ParameterizedType pType) {
        if (pType.getActualTypeArguments().length != 1) {
            return null;
        }
        Class collectionType = (Class)pType.getRawType();
        if (!this.isCollectionTypeSupported(collectionType)) {
            return null;
        }
        if (ReflectionUtil.isSetType(collectionType)) {
            return this.handleSetType(pType);
        }
        return this.handleListType(pType);
    }

    private Object handleSetType(ParameterizedType pType) {
        return new HashSet((List)this.handleListType(pType));
    }

    private Object handleListType(ParameterizedType pType) {
        Class<?> genericParameter = ReflectionUtil.getGenericParameter(pType);
        Object array = this.getValueFromMap(Array.newInstance(genericParameter, 0).getClass());
        if (array == null) {
            return null;
        }
        return Arrays.asList((Object[])array);
    }

    private boolean isCollectionTypeSupported(Class<?> collectionType) {
        return collectionType.equals(Collection.class) || collectionType.equals(List.class) || collectionType.equals(Set.class);
    }

    private Object handleArrayProperty(Class<?> clazz) {
        Class<?> componentType = clazz.getComponentType();
        if (componentType.isPrimitive()) {
            Object wrapperArray;
            Class wrapper = ClassUtils.primitiveToWrapper(componentType);
            if (wrapper != componentType && (wrapperArray = this.getValueFromMap(Array.newInstance(wrapper, 0).getClass())) != null) {
                return this.unwrapArray(wrapperArray, componentType);
            }
        } else {
            Object wrapperArray = this.getValueFromMap(Array.newInstance(componentType, 0).getClass());
            if (wrapperArray != null) {
                return this.unwrapArray(wrapperArray, componentType);
            }
        }
        return null;
    }

    private Object unwrapArray(Object wrapperArray, Class<?> primitiveType) {
        int length = Array.getLength(wrapperArray);
        Object primitiveArray = Array.newInstance(primitiveType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(primitiveArray, i, Array.get(wrapperArray, i));
        }
        return primitiveArray;
    }

    private Object getValueFromMap(Class<?> type) {
        if (this.inheritanceValueMap != null) {
            return this.inheritanceValueMap.getInherited(this.name, type);
        }
        return this.valueMap.get(this.name, type);
    }

    public Object getConvertedValue() {
        return this.convertedValue;
    }
}

