/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import acscommons.com.google.common.cache.Cache;
import acscommons.com.google.common.cache.CacheStats;
import com.adobe.acs.commons.util.impl.AbstractCacheMBean;
import com.adobe.acs.commons.util.impl.CacheMBean;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class AbstractGuavaCacheMBean<K, V>
extends AbstractCacheMBean<K, V>
implements CacheMBean {
    public <T> AbstractGuavaCacheMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    protected AbstractGuavaCacheMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    protected abstract Cache<K, V> getCache();

    @Override
    public final void clearCache() {
        this.getCache().invalidateAll();
    }

    @Override
    protected final Map<K, V> getCacheAsMap() {
        return this.getCache().asMap();
    }

    @Override
    public final TabularData getCacheStats() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("Cache Stats", "Cache Stats", new String[]{"Stat", "Value"}, new String[]{"Stat", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Stats", "Cache Stats", cacheEntryType, new String[]{"Stat"}));
        CacheStats cacheStats = this.getCache().stats();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Stat", "Request Count");
        row.put("Value", String.valueOf(cacheStats.requestCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Count");
        row.put("Value", String.valueOf(cacheStats.hitCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.hitRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Count");
        row.put("Value", String.valueOf(cacheStats.missCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.missRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Eviction Count");
        row.put("Value", String.valueOf(cacheStats.evictionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Count");
        row.put("Value", String.valueOf(cacheStats.loadCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Count");
        row.put("Value", String.valueOf(cacheStats.loadExceptionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.loadExceptionRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Success Count");
        row.put("Value", String.valueOf(cacheStats.loadSuccessCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Average Load Penalty");
        row.put("Value", String.valueOf(cacheStats.averageLoadPenalty()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Total Load Time");
        row.put("Value", String.valueOf(cacheStats.totalLoadTime()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        return tabularData;
    }
}

