/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class TypeUtil {
    private static final Logger log = LoggerFactory.getLogger(TypeUtil.class);
    private static final Pattern JSON_DATE = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");

    private TypeUtil() {
    }

    public static <T> Map<T, T> arrayToMap(T[] list) {
        HashMap<T, T> map = new HashMap<T, T>();
        if (list == null) {
            return map;
        }
        if (list.length > 0 && list.length % 2 == 1) {
            throw new IllegalArgumentException("Array must be even in length, representing a series of Key, Value pairs.");
        }
        for (int i = 0; i < list.length; i += 2) {
            map.put(list[i], list[i + 1]);
        }
        return map;
    }

    public static Map<String, Object> toMap(JsonObject json) {
        Gson gson = new Gson();
        return (Map)gson.fromJson((JsonElement)json, Map.class);
    }

    public static <T> Class<T> getType(Object object) {
        if (object instanceof Double || object instanceof Float) {
            return Double.class;
        }
        if (object instanceof Number) {
            return Long.class;
        }
        if (object instanceof Boolean) {
            return Boolean.class;
        }
        if (object instanceof String) {
            if (JSON_DATE.matcher((String)object).matches()) {
                return Date.class;
            }
        } else {
            if (object instanceof Calendar) {
                return Calendar.class;
            }
            if (object instanceof Date) {
                return Date.class;
            }
        }
        return String.class;
    }

    public static <T> T toObjectType(String data, Class<T> klass) {
        if (Double.class.equals(klass)) {
            try {
                return klass.cast(Double.parseDouble(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (Long.class.equals(klass)) {
            try {
                return klass.cast(Long.parseLong(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (Integer.class.equals(klass)) {
            try {
                return klass.cast(Long.parseLong(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (StringUtils.equalsIgnoreCase((String)"true", (String)data)) {
            return klass.cast(Boolean.TRUE);
        }
        if (StringUtils.equalsIgnoreCase((String)"false", (String)data)) {
            return klass.cast(Boolean.FALSE);
        }
        if (JSON_DATE.matcher(data).matches()) {
            long epochSeconds = OffsetDateTime.parse(data).toInstant().toEpochMilli();
            return klass.cast(new Date(epochSeconds));
        }
        return klass.cast(data);
    }

    public static String toString(Object obj, Class<?> klass) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return TypeUtil.toString(obj, klass, null);
    }

    public static String toString(Object obj, Class<?> klass, String methodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        boolean isPrimitiveOrWrapped;
        if (StringUtils.isBlank((String)methodName)) {
            methodName = "toString";
        }
        boolean bl = isPrimitiveOrWrapped = obj.getClass().isPrimitive() || ClassUtils.wrapperToPrimitive(obj.getClass()) != null;
        if (isPrimitiveOrWrapped) {
            return String.valueOf(obj);
        }
        if (Date.class.equals(klass)) {
            return ((Date)obj).toString();
        }
        if (Calendar.class.equals(klass)) {
            return ((Calendar)obj).getTime().toString();
        }
        if (TypeUtil.isArray(obj)) {
            return TypeUtil.toStringFromArray(obj);
        }
        Method method = klass.getMethod(methodName, new Class[0]);
        return (String)method.invoke(obj, new Object[0]);
    }

    public static String toString(Object obj) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        boolean isPrimitiveOrWrapped;
        if (obj == null) {
            return "null";
        }
        boolean bl = isPrimitiveOrWrapped = obj.getClass().isPrimitive() || ClassUtils.wrapperToPrimitive(obj.getClass()) != null;
        if (isPrimitiveOrWrapped) {
            return String.valueOf(obj);
        }
        if (obj instanceof Date) {
            return ((Date)obj).toString();
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime().toString();
        }
        if (TypeUtil.isArray(obj)) {
            return TypeUtil.toStringFromArray(obj);
        }
        Method method = obj.getClass().getMethod("toString", new Class[0]);
        return (String)method.invoke(obj, new Object[0]);
    }

    public static ValueMap toValueMap(Map<String, ?> map) {
        LinkedHashMap objectMap = new LinkedHashMap(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            objectMap.put(entry.getKey(), entry.getValue());
        }
        return new ValueMapDecorator(objectMap);
    }

    private static boolean isArray(Object obj) {
        return obj instanceof Object[] || obj instanceof boolean[] || obj instanceof byte[] || obj instanceof short[] || obj instanceof char[] || obj instanceof int[] || obj instanceof long[] || obj instanceof float[] || obj instanceof double[];
    }

    private static String toStringFromArray(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.deepToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        log.warn("Object is not an Array");
        return null;
    }
}

