/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class TextUtil {
    private static final Pattern RICH_TEXT_PATTERN = Pattern.compile("<[^>]+>");

    private TextUtil() {
    }

    public static <T> T getFirstNonNull(T ... values) {
        if (values == null || values.length < 1) {
            return null;
        }
        List<T> list = Arrays.asList(values);
        for (T item : list) {
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static String getFirstNonEmpty(String ... values) {
        if (values == null || values.length < 1) {
            return null;
        }
        List<String> list = Arrays.asList(values);
        for (String item : list) {
            if (!StringUtils.isNotBlank((String)item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T getFirstProperty(Resource resource, Class<T> klass, String ... keys) {
        return TextUtil.getFirstProperty((ValueMap)resource.adaptTo(ValueMap.class), klass, keys);
    }

    public static <T> T getFirstProperty(ValueMap valueMap, Class<T> klass, String ... keys) {
        if (valueMap == null || keys == null || keys.length < 1) {
            return null;
        }
        List<String> keyList = Arrays.asList(keys);
        for (String key : keyList) {
            if (!valueMap.containsKey((Object)key) || valueMap.get((Object)key) == null) continue;
            return (T)valueMap.get(key, klass);
        }
        return null;
    }

    public static boolean isRichText(String str) {
        Matcher m = RICH_TEXT_PATTERN.matcher(str);
        return m.find();
    }
}

