/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class CookieUtil {
    private CookieUtil() {
    }

    public static boolean addCookie(Cookie cookie, HttpServletResponse response) {
        if (cookie == null || response == null) {
            return false;
        }
        response.addCookie(cookie);
        return true;
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        if (StringUtils.isBlank((String)cookieName)) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        if (cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals((String)cookieName, (String)cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static List<Cookie> getCookies(HttpServletRequest request, String regex) {
        ArrayList<Cookie> foundCookies = new ArrayList<Cookie>();
        if (StringUtils.isBlank((String)regex)) {
            return foundCookies;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(regex);
        for (Cookie cookie : cookies) {
            Matcher m = p.matcher(cookie.getName());
            if (!m.matches()) continue;
            foundCookies.add(cookie);
        }
        return foundCookies;
    }

    public static boolean extendCookieLife(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookiePath, int expiry) {
        Cookie cookie = CookieUtil.getCookie(request, cookieName);
        if (cookie == null) {
            return false;
        }
        if (cookie.getMaxAge() <= 0) {
            return false;
        }
        Cookie responseCookie = (Cookie)cookie.clone();
        responseCookie.setMaxAge(expiry);
        responseCookie.setPath(cookiePath);
        CookieUtil.addCookie(responseCookie, response);
        return true;
    }

    public static int dropCookies(HttpServletRequest request, HttpServletResponse response, String cookiePath, String ... cookieNames) {
        int count = 0;
        if (cookieNames == null) {
            return count;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String cookieName : cookieNames) {
            cookies.add(CookieUtil.getCookie(request, cookieName));
        }
        return CookieUtil.dropCookies(response, cookies.toArray(new Cookie[cookies.size()]), cookiePath);
    }

    private static int dropCookies(HttpServletResponse response, Cookie[] cookies, String cookiePath) {
        int count = 0;
        for (Cookie cookie : cookies) {
            if (cookie == null) continue;
            Cookie responseCookie = (Cookie)cookie.clone();
            responseCookie.setMaxAge(0);
            responseCookie.setPath(cookiePath);
            responseCookie.setValue("");
            CookieUtil.addCookie(responseCookie, response);
            ++count;
        }
        return count;
    }

    public static int dropCookiesByRegex(HttpServletRequest request, HttpServletResponse response, String cookiePath, String ... regexes) {
        return CookieUtil.dropCookiesByRegexArray(request, response, cookiePath, regexes);
    }

    public static int dropCookiesByRegexArray(HttpServletRequest request, HttpServletResponse response, String cookiePath, String[] regexes) {
        int count = 0;
        if (regexes == null) {
            return count;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String regex : regexes) {
            cookies.addAll(CookieUtil.getCookies(request, regex));
        }
        return CookieUtil.dropCookies(response, cookies.toArray(new Cookie[cookies.size()]), cookiePath);
    }

    public static int dropAllCookies(HttpServletRequest request, HttpServletResponse response, String cookiePath) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return 0;
        }
        return CookieUtil.dropCookies(response, cookies, cookiePath);
    }
}

