/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.sorter.impl;

import com.adobe.acs.commons.sorter.NodeSorter;
import com.adobe.acs.commons.sorter.impl.HierarchyNodeComparator;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component
public class NodeNameSorter
implements NodeSorter {
    public static final String SORTER_NAME = "byName";
    public static final String RP_CASE_SENSITIVE = ":caseSensitive";

    @Override
    public String getName() {
        return SORTER_NAME;
    }

    @Override
    public String getLabel() {
        return "By Node Name";
    }

    @Override
    public Comparator<Node> createComparator(HttpServletRequest request) {
        boolean caseSensitive = Boolean.parseBoolean(request.getParameter(RP_CASE_SENSITIVE));
        boolean nonHierarchyFirst = request.getParameter(":nonHierarchyFirst") == null || Boolean.parseBoolean(request.getParameter(":nonHierarchyFirst"));
        Comparator<Node> parentComparator = nonHierarchyFirst ? HierarchyNodeComparator.INSTANCE : (n1, n2) -> 0;
        return parentComparator.thenComparing((n1, n2) -> {
            try {
                String name1 = n1.getName();
                String name2 = n2.getName();
                return caseSensitive ? name1.compareTo(name2) : name1.compareToIgnoreCase(name2);
            }
            catch (RepositoryException e) {
                return 0;
            }
        });
    }
}

