/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.granite.references.Reference;
import com.adobe.granite.references.ReferenceAggregator;
import com.adobe.granite.references.ReferenceList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;

@Model(adaptables={Resource.class})
public class ReferencesModel
implements ReportCellCSVExporter {
    @Inject
    @OSGiService
    private ReferenceAggregator aggregator;
    private ReferenceList referenceList;
    private Resource resource;

    public ReferencesModel(Resource resource) {
        this.resource = resource;
    }

    public List<Reference> getReferences() {
        return Optional.ofNullable(this.referenceList).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    @Override
    public String getValue(Object result) {
        this.resource = (Resource)result;
        this.init();
        ArrayList<String> refStrings = new ArrayList<String>();
        for (Reference reference : this.referenceList) {
            refStrings.add(reference.getType() + " - " + reference.getTarget().getPath());
        }
        return StringUtils.join(refStrings, (String)";");
    }

    @PostConstruct
    public void init() {
        this.referenceList = this.aggregator.createReferenceList(this.resource);
        Iterator references = this.referenceList.iterator();
        while (references.hasNext()) {
            if (!((Reference)references.next()).getTarget().getPath().equals(this.resource.getPath())) continue;
            references.remove();
        }
    }
}

