/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.api;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ResultsPage {
    private final Stream<? extends Object> results;
    private final int pageSize;
    private final int page;
    private final long resultSize;

    public ResultsPage(Stream<? extends Object> results, int pageSize, int page, long resultSize) {
        this.results = results;
        this.resultSize = resultSize;
        this.pageSize = pageSize;
        this.page = page;
    }

    public Stream<Object> getResults() {
        return this.results;
    }

    public List<Object> getResultsList() {
        return this.results.collect(Collectors.toList());
    }

    public long getResultsStart() {
        return this.page != -1 ? (long)(this.pageSize * this.page + 1) : 1L;
    }

    public long getResultsEnd() {
        return this.page != -1 ? (long)(this.pageSize * this.page) + this.resultSize : this.resultSize;
    }

    public int getNextPage() {
        return this.resultSize == (long)this.pageSize && this.page != -1 ? this.page + 1 : -1;
    }

    public int getPreviousPage() {
        return this.page > 0 ? this.page - 1 : -1;
    }

    public long getResultSize() {
        return this.resultSize;
    }
}

