/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.packages.automatic.impl;

import com.adobe.acs.commons.replication.packages.automatic.impl.AutomaticPackageReplicatorJob;
import com.day.cq.replication.Replicator;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(label="Workflow Label", name="process.label", value={"Build and Replicate Package"}, description="Builds and Replicates a Package of Content, set the path of the package to replicate as the argument.")
@Service
public class ReplicatePackageProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicatePackageProcess.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Replicator replicator;
    @Reference
    private EventAdmin eventAdmin;

    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
        log.trace("execute");
        String packagePath = (String)args.get("PROCESS_ARGS", String.class);
        if (StringUtils.isNotEmpty((CharSequence)packagePath)) {
            log.debug("Executing Automatic Package Replicator Job for package {}", (Object)packagePath);
            AutomaticPackageReplicatorJob aprJob = new AutomaticPackageReplicatorJob(this.resourceResolverFactory, this.replicator, this.eventAdmin, packagePath);
            try {
                aprJob.excute();
            }
            catch (Exception e) {
                log.error("Exception executing Automatic Package Replicator Job for package " + packagePath, (Throwable)e);
                throw new WorkflowException("Exception executing Automatic Package Replicator Job for package " + packagePath, (Throwable)e);
            }
        } else {
            log.warn("No package path specified");
            throw new WorkflowException("No package path specified for Automatic Package Replicator Job");
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

