/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.day.cq.replication.ContentBuilder;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationLog;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Session;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={ContentBuilder.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"service.description=ACS Commons Re-fetch Flush Content Builder", "webconsole.configurationFactory.nameHint=Extension Mapping: [{extension.pairs}] Match: [{match.paths}]", "name=flush_refetch"}, immediate=true)
public class RefetchFlushContentBuilderImpl
implements ContentBuilder {
    private static final Logger log = LoggerFactory.getLogger(RefetchFlushContentBuilderImpl.class);
    private ReplicationLog replicationLog;
    private static final String CONTENT_BUILDER_NAME = "flush_refetch";
    public static final String TITLE = "Dispatcher Flush Re-fetch";
    public static final String SERVICE_NAME = "flush_refetch";
    private static final String[] DEFAULT_MATCH_PATH = new String[]{"*"};
    private String[] pathMatches = DEFAULT_MATCH_PATH;
    private Map<String, String[]> extensionPairs = new LinkedHashMap<String, String[]>();

    @Activate
    protected void activate(Config config) {
        this.extensionPairs = this.formatExtensions(ParameterUtil.toMap(config.extension_pairs(), "=", false, null, false));
        this.logInfoMessage("Extension Pairs [" + this.mapToString(this.extensionPairs) + "]");
        ArrayList<String> validMatches = new ArrayList<String>();
        String[] matchProps = config.match_paths();
        if (matchProps.length > 0) {
            for (String match : matchProps) {
                if (!StringUtils.isNotEmpty((CharSequence)match)) continue;
                validMatches.add(match);
            }
        }
        this.pathMatches = validMatches.toArray(new String[0]);
        this.logInfoMessage("Match Path Patterns [" + String.join((CharSequence)",", this.pathMatches) + "]");
    }

    private Map<String, String[]> formatExtensions(Map<String, String> configuredExtensions) {
        LinkedHashMap<String, String[]> extensions = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String> entry : configuredExtensions.entrySet()) {
            String ext = entry.getKey().trim();
            extensions.put(ext, entry.getValue().trim().split("&"));
        }
        return extensions;
    }

    public ReplicationContent create(Session session, ReplicationAction replicationAction, ReplicationContentFactory factory, Map<String, Object> options) throws ReplicationException {
        return this.create(session, replicationAction, factory);
    }

    public ReplicationContent create(Session session, ReplicationAction action, ReplicationContentFactory factory) throws ReplicationException {
        String path = action.getPath();
        this.replicationLog = action.getLog();
        if (this.replicationLog == null) {
            this.logWarnMessage("No replication log found on agent flush_refetch");
        }
        this.checkValidity(action, path);
        if (this.shouldIgnore(action, path)) {
            return ReplicationContent.VOID;
        }
        this.logInfoMessage("Content builder invoked for path " + path + ", with replication action " + action.getType() + " and serialization type " + action.getConfig().getSerializationType());
        Object[] uris = new String[]{path};
        int extSep = path.indexOf(46, path.lastIndexOf(47));
        if (extSep > 0 && MapUtils.isNotEmpty(this.extensionPairs)) {
            try {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(path);
                Object[] values = this.getExtensionPairs(path);
                if (ArrayUtils.isNotEmpty((Object[])values)) {
                    String withoutExt = FilenameUtils.removeExtension((String)path) + ".";
                    for (Object next : values) {
                        paths.add(withoutExt + (String)next);
                    }
                }
                uris = paths.toArray(new String[0]);
            }
            catch (Exception e) {
                this.logErrorMessage("Replicated cancelled: " + e.getMessage());
                return ReplicationContent.VOID;
            }
        }
        this.logInfoMessage("Replicating with Re-Fetch: " + Arrays.toString(uris));
        return this.createContent(factory, (String[])uris);
    }

    private ReplicationContent createContent(ReplicationContentFactory factory, String[] uris) throws ReplicationException {
        ReplicationContent replicationContent;
        block9: {
            Path tmpFile = null;
            BufferedWriter out = null;
            try {
                tmpFile = Files.createTempFile("cq5", ".post", new FileAttribute[0]);
                out = Files.newBufferedWriter(tmpFile, new OpenOption[0]);
                for (String nextUri : uris) {
                    out.write(nextUri);
                    out.newLine();
                    this.logDebugMessage("TempFile: adding " + nextUri);
                }
                out.close();
                replicationContent = factory.create("text/plain", tmpFile.toFile(), true);
                if (out == null) break block9;
            }
            catch (IOException e) {
                try {
                    try {
                        if (tmpFile != null) {
                            Files.delete(tmpFile);
                        }
                    }
                    catch (Exception exception) {
                        this.logInfoMessage("Could not delete repository content temporary file: " + tmpFile.toString());
                    }
                    throw new ReplicationException("Error with temporary repository content", (Exception)e);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        IOUtils.closeQuietly(out);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)out);
        }
        return replicationContent;
    }

    private void logErrorMessage(String message) {
        if (this.replicationLog != null) {
            this.replicationLog.error(message);
        } else if (log != null) {
            log.error(message);
        }
    }

    private void logWarnMessage(String message) {
        if (this.replicationLog != null) {
            this.replicationLog.warn(message);
        } else if (log != null) {
            log.warn(message);
        }
    }

    private void logInfoMessage(String message) {
        if (this.replicationLog != null) {
            this.replicationLog.info(message);
        } else if (log != null) {
            log.info(message);
        }
    }

    private void logDebugMessage(String message) {
        if (this.replicationLog != null) {
            this.replicationLog.debug(message);
        } else if (log != null) {
            log.debug(message);
        }
    }

    private void checkValidity(ReplicationAction action, String path) throws ReplicationException {
        if (action.getType() != ReplicationActionType.ACTIVATE && action.getType() != ReplicationActionType.TEST) {
            this.logErrorMessage("No re-fetch handling for replication action " + action.getType().getName());
            throw new ReplicationException("No re-fetch handling for replication action " + action.getType().getName());
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            this.logErrorMessage("No path found for re-fetch replication.");
            throw new ReplicationException("No path found for re-fetch replication.");
        }
        if (!"flush_refetch".equals(action.getConfig().getSerializationType())) {
            String message = "Serialization type '" + action.getConfig().getSerializationType() + "' not supported by Flush Re-Fetch Content Builder.";
            this.logErrorMessage(message);
            throw new ReplicationException(message);
        }
    }

    private boolean shouldIgnore(ReplicationAction action, String path) {
        if (!this.pathMatchesFilter(this.pathMatches, path)) {
            this.logInfoMessage("Path does not match filters provided. IGNORING " + path);
            return true;
        }
        if (action.getType() == ReplicationActionType.TEST) {
            return true;
        }
        int pathSep = path.lastIndexOf(47);
        if (pathSep < 0) {
            this.logWarnMessage("Activation on a non-path value.  IGNORING: " + path);
            return true;
        }
        return false;
    }

    private String mapToString(Map<String, String[]> map) {
        StringBuilder output = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] values;
            if (!first) {
                output.append(",");
            }
            first = false;
            output.append(entry.getKey());
            output.append("=[");
            boolean firstValue = true;
            for (String nextValue : values = entry.getValue()) {
                if (!firstValue) {
                    output.append(",");
                }
                firstValue = false;
                output.append(nextValue);
            }
            output.append("]");
        }
        return output.toString();
    }

    private boolean pathMatchesFilter(String[] filters, String path) {
        boolean matches = false;
        for (String filter : filters) {
            try {
                if (!filter.equals("*") && !path.matches(filter)) continue;
                matches = true;
                break;
            }
            catch (PatternSyntaxException ex) {
                this.logErrorMessage("Ignoring invalid regex filter: [" + filter + "].  Reason: " + ex.getMessage());
            }
        }
        return matches;
    }

    private String[] getExtensionPairs(String path) {
        String extension = FilenameUtils.getExtension((String)path);
        return this.extensionPairs.get(extension);
    }

    final Map<String, String[]> getExtensionPairs() {
        return this.extensionPairs;
    }

    final String[] getPathMatches() {
        return Optional.ofNullable(this.pathMatches).map(array -> Arrays.copyOf(array, ((String[])array).length)).orElse(DEFAULT_MATCH_PATH);
    }

    public String getName() {
        return "flush_refetch";
    }

    public String getTitle() {
        return TITLE;
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Dispatcher Flush with Re-fetch", description="Instead of deleting pages from the Dispatcher cache, update the last modified time (.stat) of the targeted file, and trigger an immediate request of the page.")
    static @interface Config {
        @AttributeDefinition(name="Path Pattern", description="Specify a regex to match paths to be included in the re-fetch flush (i.e. * for all paths, /content/.* for all paths under /content, .*.html for all paths with html as its extension)", cardinality=0x7FFFFFFF)
        public String[] match_paths() default {"*"};

        @AttributeDefinition(name="Extension Pairs", description="To activate paired pages with re-fetch, specify the original extension (i.e. html) and map it to any other extensions (i.e. header_include.html)", cardinality=0x7FFFFFFF)
        public String[] extension_pairs() default {};
    }
}

