/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.util.AccessibleObjectUtil;
import com.adobe.acs.commons.mcp.util.DeserializeException;
import com.adobe.acs.commons.mcp.util.IntrospectionUtil;
import com.adobe.acs.commons.mcp.util.ValueMapSerializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedFieldDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedFieldDeserializer.class);

    public static void deserializeFormFields(Object target, ValueMap input) throws DeserializeException {
        List fields = FieldUtils.getFieldsListWithAnnotation(target.getClass(), FormField.class);
        AnnotatedFieldDeserializer.deserializeFields(target, fields, input);
    }

    public static void deserializeFields(Object target, List<Field> fields, ValueMap input) throws DeserializeException {
        for (Field field : fields) {
            try {
                AnnotatedFieldDeserializer.parseInput(target, input, field);
            }
            catch (NullPointerException | ReflectiveOperationException | ParseException ex) {
                throw new DeserializeException("Error when processing field " + field.getName(), ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseInput(Object target, ValueMap input, Field field) throws ReflectiveOperationException, ParseException {
        Object value;
        FormField inputAnnotation = field.getAnnotation(FormField.class);
        if (input.get((Object)field.getName()) == null) {
            if (field.getType() != Boolean.class && field.getType() != Boolean.TYPE) {
                if (inputAnnotation == null) return;
                if (!inputAnnotation.required()) return;
                throw new NullPointerException("Required field missing: " + field.getName());
            }
            value = false;
        } else {
            value = input.get((Object)field.getName());
        }
        if (IntrospectionUtil.hasMultipleValues(field.getType())) {
            AnnotatedFieldDeserializer.parseInputList(target, ValueMapSerializer.serializeToStringArray(value), field);
            return;
        }
        Object val = value;
        if (value.getClass().isArray()) {
            val = ((Object[])value)[0];
        }
        if (!(val instanceof RequestParameter)) {
            AnnotatedFieldDeserializer.parseInputValue(target, String.valueOf(val), field);
            return;
        }
        if (field.getType() == RequestParameter.class) {
            FieldUtils.writeField((Field)field, (Object)target, (Object)val, (boolean)true);
            return;
        }
        try {
            FieldUtils.writeField((Field)field, (Object)target, (Object)((RequestParameter)val).getInputStream(), (boolean)true);
            return;
        }
        catch (IOException ex) {
            LOG.error("Unable to get InputStream for uploaded file [ {} ]", (Object)((RequestParameter)val).getName(), (Object)ex);
            return;
        }
    }

    private static void parseInputList(Object target, String[] values, Field field) throws ReflectiveOperationException, ParseException {
        ArrayList<Object> convertedValues = new ArrayList<Object>();
        Class<?> type = IntrospectionUtil.getCollectionComponentType(field);
        for (String value : values) {
            Object val = AnnotatedFieldDeserializer.convertValue(value, type);
            convertedValues.add(val);
        }
        if (field.getType().isArray()) {
            Object array = Array.newInstance(field.getType().getComponentType(), convertedValues.size());
            for (int i = 0; i < convertedValues.size(); ++i) {
                Array.set(array, i, convertedValues.get(i));
            }
            FieldUtils.writeField((Field)field, (Object)target, (Object)array, (boolean)true);
        } else {
            Collection c = (Collection)AnnotatedFieldDeserializer.getInstantiatableListType(field.getType()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            c.addAll(convertedValues);
            FieldUtils.writeField((Field)field, (Object)target, (Object)c, (boolean)true);
        }
    }

    private static void parseInputValue(Object target, String value, Field field) throws ReflectiveOperationException, ParseException {
        FieldUtils.writeField((Field)field, (Object)target, (Object)AnnotatedFieldDeserializer.convertValue(value, field.getType()), (boolean)true);
    }

    private static Object convertValue(String value, Class<?> type) throws ParseException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = type.isArray() ? type.getComponentType() : type;
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Boolean.class) {
            return AnnotatedFieldDeserializer.convertPrimitiveValue(value, clazz);
        }
        if (clazz == String.class) {
            return value;
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, value);
        }
        return null;
    }

    private static Object convertPrimitiveValue(String value, Class<?> type) throws ParseException {
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return value.toLowerCase().trim().equals("true");
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number num = numberFormat.parse(value);
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return num.byteValue();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return num.doubleValue();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(num.floatValue());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return num.intValue();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return num.longValue();
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return num.shortValue();
        }
        return null;
    }

    private static Class getInstantiatableListType(Class<?> type) {
        if (type == List.class || type == Collection.class || type == Iterable.class) {
            return ArrayList.class;
        }
        if (type == Set.class) {
            return LinkedHashSet.class;
        }
        return type;
    }

    public static Stream<AccessibleObject> getAllAnnotatedObjectMembers(Class source, Class<? extends Annotation> annotation) {
        return Stream.concat(FieldUtils.getFieldsListWithAnnotation((Class)source, annotation).stream().sorted(AnnotatedFieldDeserializer::superclassFieldsFirst), MethodUtils.getMethodsListWithAnnotation((Class)source, annotation).stream());
    }

    public static Map<String, FieldComponent> getFormFields(Class source, SlingScriptHelper sling) {
        LinkedHashMap<String, FieldComponent> comps = new LinkedHashMap<String, FieldComponent>();
        Map<String, String> globalLangs = AnnotatedFieldDeserializer.loadLanguages(sling);
        AnnotatedFieldDeserializer.getAllAnnotatedObjectMembers(source, FormField.class).forEach(f -> {
            FormField fieldDefinition = f.getAnnotation(FormField.class);
            if (fieldDefinition.localize()) {
                comps.putAll(AnnotatedFieldDeserializer.createLocalizedComponent(sling, f, fieldDefinition, globalLangs));
            } else {
                try {
                    FieldComponent component = fieldDefinition.component().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    component.setup(AccessibleObjectUtil.getFieldName(f), (AccessibleObject)f, fieldDefinition, sling);
                    comps.put(AccessibleObjectUtil.getFieldName(f), component);
                }
                catch (ReflectiveOperationException | RuntimeException ex) {
                    LOG.error("Unable to instantiate field component for " + f.toString(), (Throwable)ex);
                }
            }
        });
        return comps;
    }

    private static Map<String, String> loadLanguages(SlingScriptHelper sling) {
        LinkedHashMap<String, String> globalLangs = new LinkedHashMap<String, String>();
        if (sling != null) {
            String LANGUAGE_NODE_PATH = "wcm/core/resources/languages";
            Resource rootRes = sling.getRequest().getResourceResolver().getResource("wcm/core/resources/languages");
            if (rootRes != null) {
                Iterator itr = rootRes.listChildren();
                while (itr.hasNext()) {
                    Resource langRes = (Resource)itr.next();
                    String language = (String)langRes.getValueMap().get("language", (Object)"");
                    String country = (String)langRes.getValueMap().get("country", (Object)"");
                    if (!country.isEmpty() && !country.equals("*")) {
                        language = language + " - " + country;
                    }
                    globalLangs.put(langRes.getName(), language);
                }
            }
        }
        return globalLangs;
    }

    private static Map<String, FieldComponent> createLocalizedComponent(SlingScriptHelper sling, AccessibleObject accessibleObject, FormField fieldDefinition, Map<String, String> globalLangs) {
        LinkedHashMap<String, FieldComponent> comps = new LinkedHashMap<String, FieldComponent>();
        String[] langs = fieldDefinition.languages();
        if (langs == null || langs.length < 2) {
            langs = globalLangs.keySet().toArray(new String[1]);
        }
        for (String lang : langs) {
            String fieldName = AccessibleObjectUtil.getFieldName(accessibleObject) + (lang.equalsIgnoreCase("en") ? "" : "." + lang);
            String title = fieldDefinition.name() + (lang.equalsIgnoreCase("en") ? "" : " (" + globalLangs.get(lang) + ")");
            try {
                FieldComponent component = fieldDefinition.component().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                component.setup(fieldName, accessibleObject, fieldDefinition, sling);
                component.getComponentMetadata().put("fieldLabel", (Object)title);
                comps.put(fieldName, component);
            }
            catch (ReflectiveOperationException | RuntimeException ex) {
                LOG.error("Unable to instantiate field component for " + accessibleObject.toString(), (Throwable)ex);
            }
        }
        return comps;
    }

    private static int superclassFieldsFirst(Field a, Field b) {
        if (a.getDeclaringClass() == b.getDeclaringClass()) {
            return 0;
        }
        if (a.getDeclaringClass().isAssignableFrom(b.getDeclaringClass())) {
            return -1;
        }
        return 1;
    }

    private AnnotatedFieldDeserializer() {
    }
}

