/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.ArchivedProcessFailure;
import com.adobe.acs.commons.mcp.model.Result;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@ProviderType
public class ManagedProcess
implements Serializable {
    private static final long serialVersionUID = 7526472295622776156L;
    @Inject
    private String requester;
    @Inject
    private ValueMap requestInputs;
    @Inject
    private Long startTime;
    @Inject
    private Long stopTime;
    @Inject
    private String name;
    @Inject
    private String description;
    @Inject
    private boolean isRunning;
    @Inject
    private double progress;
    @Inject
    private String status;
    @Inject
    private Result result;
    @Inject
    private int reportedErrors = 0;
    private transient Collection<ArchivedProcessFailure> reportedErrorsList;
    @Inject
    private transient Resource resource;

    public int getReportedErrors() {
        return this.reportedErrors;
    }

    public Collection<ArchivedProcessFailure> getReportedErrorsList() {
        return Optional.ofNullable(this.reportedErrorsList).map(Collections::unmodifiableCollection).orElse(Collections.emptyList());
    }

    public void setReportedErrors(List<ArchivedProcessFailure> reportedErrors) {
        this.reportedErrorsList = Collections.unmodifiableList(reportedErrors);
        this.reportedErrors = this.reportedErrorsList.size();
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public ValueMap getRequestInputs() {
        return this.requestInputs;
    }

    public void setRequestInputs(ValueMap requestInputs) {
        this.requestInputs = requestInputs;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getStartTimeFormatted() {
        return this.startTime != null ? this.formatDate(this.startTime) : "";
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStopTime() {
        return this.stopTime;
    }

    public String getStopTimeFormatted() {
        return this.stopTime != null ? this.formatDate(this.stopTime) : "";
    }

    public void setStopTime(Long stopTime) {
        this.stopTime = stopTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isIsRunning() {
        return this.isRunning;
    }

    public void setIsRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public double getProgress() {
        return this.progress;
    }

    public String getProgressPercent() {
        return String.format("%.1f%%", this.progress * 100.0);
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @PostConstruct
    private void readErrors() {
        Resource failuresRoot = this.resource.getChild("failures");
        if (failuresRoot != null && failuresRoot.hasChildren()) {
            ArrayList<ArchivedProcessFailure> failures = new ArrayList<ArchivedProcessFailure>();
            failuresRoot.getChildren().forEach(step -> step.getChildren().forEach(f -> failures.add((ArchivedProcessFailure)f.adaptTo(ArchivedProcessFailure.class))));
            this.setReportedErrors(failures);
        }
    }

    private String formatDate(long time) {
        Calendar today = Calendar.getInstance();
        today.clear(11);
        today.clear(12);
        today.clear(13);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        DateFormat format = cal.after(today) ? DateFormat.getTimeInstance() : DateFormat.getDateTimeInstance();
        return format.format(new Date(time));
    }
}

