/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.renovator;

import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.impl.processes.renovator.MovingException;
import com.day.cq.replication.ReplicationStatus;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class Util {
    private Util() {
    }

    public static boolean resourceExists(ResourceResolver rr, String path) {
        Resource res = rr.getResource(path);
        return res != null && !"sling:nonexisting".equals(res.getResourceType());
    }

    public static void waitUntilResourceFound(ResourceResolver rr, String path) throws MovingException {
        try {
            Actions.retry(10, 100L, resolver -> {
                if (!Util.resourceExists(resolver, path)) {
                    throw new RepositoryException("Resource not found: " + path);
                }
            }).accept(rr);
        }
        catch (Exception e) {
            throw new MovingException(path, e);
        }
    }

    public static boolean isActivated(ResourceResolver rr, String path) {
        Resource res = rr.getResource(path);
        if (res == null) {
            return false;
        }
        ReplicationStatus replicationStatus = (ReplicationStatus)res.adaptTo(ReplicationStatus.class);
        if (replicationStatus == null) {
            return false;
        }
        return replicationStatus.isActivated();
    }

    public static String[] listToStringArray(List<String> values) {
        return values.toArray(new String[0]);
    }
}

