/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.DatePickerComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.MultifieldComponent;
import com.adobe.acs.commons.mcp.form.NumberfieldComponent;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalConfig;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;

public class WorkflowRemover
extends ProcessDefinition {
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_DURATION_MINS = 0;
    private final WorkflowInstanceRemover workflowInstanceRemover;
    private final transient GenericBlobReport report = new GenericBlobReport();
    private final transient List<EnumMap<ReportColumns, Object>> reportRows = new ArrayList<EnumMap<ReportColumns, Object>>();
    @FormField(name="Workflow Payload Paths", description="Payload path regex", hint="/content/dam/.*", component=MultifieldComponent.class)
    public List<String> payloadPaths;
    @FormField(name="Workflows Older Than", description="only remove workflows older than the specified date", component=DatePickerComponent.class)
    public String olderThanVal;
    @FormField(name="Workflows Older Than Milliseconds", description="only remove workflows that were started longer than the specified milliseconds ago", component=NumberfieldComponent.class)
    public long olderThanMillis;
    @FormField(name="Workflow Models", description="If no Workflow Models are selected, Workflow Instances will not be filtered by Workflow Model.", component=MultifieldComponent.class, options={"use_class=com.adobe.acs.commons.mcp.form.workflow.WorkflowModelSelector"})
    public List<String> modelIds = new ArrayList<String>();
    private List<Pattern> payloads = new ArrayList<Pattern>();
    private Calendar olderThan;
    @FormField(name="Workflow Statuses", component=MultifieldComponent.class, required=true, options={"use_class=com.adobe.acs.commons.mcp.form.workflow.WorkflowStatusSelector"})
    public List<String> statuses = new ArrayList<String>();
    private WorkflowRemovalConfig workflowRemovalConfig;

    public WorkflowRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        this.workflowInstanceRemover = workflowInstanceRemover;
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.defineCriticalAction("Seek and Destroy Workflows", rr, this::performCleanupActivity);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    @Override
    public void init() throws RepositoryException {
    }

    void performCleanupActivity(ActionManager manager) throws Exception {
        manager.withResolver(rr -> {
            this.parseParameters();
            this.workflowInstanceRemover.removeWorkflowInstances((ResourceResolver)rr, this.workflowRemovalConfig);
            WorkflowRemovalStatus status = this.workflowInstanceRemover.getStatus();
            EnumMap<ReportColumns, Object> reportRow = this.report(status);
            this.reportRows.add(reportRow);
        });
    }

    EnumMap<ReportColumns, Object> report(WorkflowRemovalStatus status) {
        EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        row.put(ReportColumns.STARTED, status.getStartedAt());
        row.put(ReportColumns.CHECKED, Integer.valueOf(status.getChecked()));
        row.put(ReportColumns.REMOVED, Integer.valueOf(status.getRemoved()));
        row.put(ReportColumns.COMPLETED, status.getCompletedAt());
        row.put(ReportColumns.ERRED, status.getErredAt());
        row.put(ReportColumns.INITIATED_BY, status.getInitiatedBy());
        return row;
    }

    void parseParameters() throws ParseException {
        if (this.payloadPaths != null) {
            this.payloads = this.payloadPaths.stream().map(Pattern::compile).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((String)this.olderThanVal)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date d = sdf.parse(this.olderThanVal);
            this.olderThan = Calendar.getInstance();
            this.olderThan.setTime(d);
        }
        this.workflowRemovalConfig = new WorkflowRemovalConfig(this.modelIds, this.statuses, this.payloads, this.olderThan, this.olderThanMillis);
        this.workflowRemovalConfig.setBatchSize(1000);
        this.workflowRemovalConfig.setMaxDurationInMins(0);
    }

    public List<String> getModelIds() {
        return Collections.unmodifiableList(this.modelIds);
    }

    public List<Pattern> getPayloads() {
        return Collections.unmodifiableList(this.payloads);
    }

    public Calendar getOlderThan() {
        return this.olderThan;
    }

    public long getOlderThanMillis() {
        return this.olderThanMillis;
    }

    public List<String> getStatuses() {
        return Collections.unmodifiableList(this.statuses);
    }

    public WorkflowRemovalConfig getWorkflowRemovalConfig() {
        return this.workflowRemovalConfig;
    }

    public static enum ReportColumns {
        STARTED,
        CHECKED,
        REMOVED,
        COMPLETED,
        ERRED,
        INITIATED_BY;

    }
}

