/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import com.adobe.acs.commons.mcp.form.TextareaComponent;
import com.adobe.acs.commons.mcp.form.workflow.WorkflowModelSelector;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.adobe.acs.commons.util.QueryHelper;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.day.cq.workflow.WorkflowException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkWorkflow
extends ProcessDefinition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BulkWorkflow.class);
    public static final String PROCESS_NAME = "Bulk Workflow";
    private final transient QueryHelper queryHelper;
    private final transient SyntheticWorkflowRunner syntheticWorkflowRunner;
    @FormField(name="Workflow model", description="The workflow model to execute. This workflow model MUST be compatible with ACS AEM Commons Synthetic Workflow.", component=WorkflowModelSelector.class, options={"required"})
    public String workflowId = "";
    @FormField(name="Query language", description="", component=SelectComponent.EnumerationSelector.class, options={"default=QUERY_BUILDER", "required"})
    public QueryLanguage queryLanguage = QueryLanguage.QUERY_BUILDER;
    @FormField(name="Query statement", description="Ensure that this query is correct prior to submitting form as it will collect the resources for processing which can be an expensive operation for large bulk workflow processes.", component=TextareaComponent.class, options={"required"})
    public String queryStatement = "";
    @FormField(name="Relative path", description="This can be used to select otherwise difficult to search for resources. Examples: jcr:content/renditions/original OR ../renditions/original")
    public String relativePayloadPath = "";
    private final transient GenericBlobReport report = new GenericBlobReport();
    private final transient List<EnumMap<ReportColumns, Object>> reportRows = new ArrayList<EnumMap<ReportColumns, Object>>();
    private transient List<Resource> payloads;
    private transient SyntheticWorkflowModel syntheticWorkflowModel;

    public BulkWorkflow(QueryHelper queryHelper, SyntheticWorkflowRunner syntheticWorkflowRunner) {
        this.queryHelper = queryHelper;
        this.syntheticWorkflowRunner = syntheticWorkflowRunner;
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException {
        this.report.setName(instance.getName());
        instance.getInfo().setDescription("Bulk process payloads using synthetic workflow");
        instance.defineCriticalAction("Process payloads with synthetic workflow", rr, this::processPayloads);
    }

    protected void queryPayloads(ActionManager manager) throws Exception {
        manager.withResolver(resourceResolver -> {
            this.payloads = this.queryHelper.findResources((ResourceResolver)resourceResolver, this.queryLanguage.getValue(), this.queryStatement, this.relativePayloadPath);
        });
    }

    protected void prepareSyntheticWorkflowModel(ActionManager manager) throws Exception {
        manager.withResolver(resourceResolver -> {
            this.syntheticWorkflowModel = this.syntheticWorkflowRunner.getSyntheticWorkflowModel((ResourceResolver)resourceResolver, this.workflowId, true);
        });
    }

    public void processPayloads(ActionManager manager) throws Exception {
        this.prepareSyntheticWorkflowModel(manager);
        this.queryPayloads(manager);
        log.info("Executing synthetic workflow [ {} ] against [ {} ] payloads via Bulk Workflow MCP process.", (Object)this.workflowId, (Object)this.payloads.size());
        this.payloads.stream().map(resource -> resource.getPath()).forEach(path -> manager.deferredWithResolver(resourceResolver -> {
            long start = System.currentTimeMillis();
            ((Session)resourceResolver.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
            try {
                this.syntheticWorkflowRunner.execute((ResourceResolver)resourceResolver, (String)path, this.syntheticWorkflowModel, false, true);
                long duration = System.currentTimeMillis() - start;
                this.record((String)path, ItemStatus.SUCCESS, duration);
                log.debug("Successfully processed payload [ {} ] with synthetic workflow [ {} ] in [ {} ] milliseconds.", new Object[]{path, this.workflowId, duration});
            }
            catch (WorkflowException e) {
                long duration = System.currentTimeMillis() - start;
                this.record((String)path, ItemStatus.FAILURE, duration);
                log.warn("Failed to process payload [ {} ] with synthetic workflow [ {} ] in [ {} ] milliseconds.", new Object[]{path, this.workflowId, duration});
            }
        }));
    }

    public GenericBlobReport getReport() {
        return this.report;
    }

    @Override
    public void init() throws RepositoryException {
    }

    protected void record(String path, ItemStatus status, long timeTaken) {
        EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        row.put(ReportColumns.PAYLOAD_PATH, path);
        row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
        row.put(ReportColumns.TIME_TAKEN_IN_MILLISECONDS, Long.valueOf(timeTaken));
        this.reportRows.add(row);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver resourceResolver) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(resourceResolver, instance.getPath() + "/jcr:content/report");
    }

    public static enum ReportColumns {
        PAYLOAD_PATH,
        TIME_TAKEN_IN_MILLISECONDS,
        STATUS;

    }

    public static enum QueryLanguage {
        QUERY_BUILDER("queryBuilder"),
        LIST("list"),
        XPATH("xpath"),
        JCR_SQL2("JCR-SQL2"),
        JCR_SQL("JCR-SQL");

        private String value;

        private QueryLanguage(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ItemStatus {
        SUCCESS,
        FAILURE;

    }
}

