/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.util.AccessibleObjectUtil;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.osgi.annotation.versioning.ProviderType;

public abstract class SelectComponent
extends FieldComponent {
    @Override
    public void init() {
        this.setResourceType("granite/ui/components/coral/foundation/form/select");
        this.getComponentMetadata().put("text", (Object)this.getFieldDefinition().name());
    }

    @Override
    public Resource buildComponentResource() {
        AbstractResourceImpl component = (AbstractResourceImpl)super.buildComponentResource();
        AbstractResourceImpl options = new AbstractResourceImpl("items", null, null, new ResourceMetadata());
        component.addChild((Resource)options);
        String defaultValue = this.getOption("default").orElse(null);
        this.getOptions().forEach((value, name) -> {
            ResourceMetadata meta = new ResourceMetadata();
            String nodeName = JcrUtil.escapeIllegalJcrChars((String)value);
            if (value.equals(defaultValue)) {
                meta.put("selected", (Object)true);
            }
            meta.put("value", value);
            meta.put("text", name);
            AbstractResourceImpl option = new AbstractResourceImpl("option_" + nodeName, null, null, meta);
            options.addChild((Resource)option);
        });
        return component;
    }

    public abstract Map<String, String> getOptions();

    @ProviderType
    public static class EnumerationSelector
    extends SelectComponent {
        @Override
        public Map<String, String> getOptions() {
            return Stream.of((Enum[])AccessibleObjectUtil.getType(this.getAccessibleObject()).getEnumConstants()).collect(Collectors.toMap(Enum::name, e -> StringUtil.getFriendlyName(e.name()), (k, v) -> {
                throw new IllegalArgumentException("cannot merge");
            }, LinkedHashMap::new));
        }
    }
}

