/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractContainerComponent;
import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class MultifieldComponent
extends AbstractContainerComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MultifieldComponent.class);
    public static final String FIELD_PATH = "/field";
    public static final String NODE_PATH = "node_path";
    public static final String ASSET_PATH = "asset_path";
    public static final String FOLDER_PATH = "folder_path";
    public static final String USE_CLASS = "use_class";

    public MultifieldComponent() {
        this.setResourceType("granite/ui/components/coral/foundation/form/multifield");
    }

    @Override
    public void init() {
        if (this.hasOption(NODE_PATH)) {
            this.setDefaultChildComponent(PathfieldComponent.NodeSelectComponent.class);
        } else if (this.hasOption(ASSET_PATH)) {
            this.setDefaultChildComponent(PathfieldComponent.AssetSelectComponent.class);
        } else if (this.hasOption(FOLDER_PATH)) {
            this.setDefaultChildComponent(PathfieldComponent.FolderSelectComponent.class);
        } else {
            this.getOption(USE_CLASS).ifPresent(c -> {
                try {
                    this.setDefaultChildComponent(Class.forName(c));
                }
                catch (ClassNotFoundException ex) {
                    LOG.error("Unable to find class {}", (Throwable)ex);
                }
            });
        }
        super.init();
    }

    @Override
    public Resource buildComponentResource() {
        this.getComponentMetadata().put("composite", (Object)this.isComposite());
        AbstractResourceImpl res = new AbstractResourceImpl(this.getPath(), this.getResourceType(), this.getResourceSuperType(), this.getComponentMetadata());
        if (this.getHelper() != null) {
            res.setResourceResolver(this.getHelper().getRequest().getResourceResolver());
        }
        if (this.isComposite()) {
            AbstractResourceImpl field = new AbstractResourceImpl(this.getPath() + FIELD_PATH, "granite/ui/components/coral/foundation/container", this.getResourceSuperType(), new ResourceMetadata());
            field.getResourceMetadata().put("name", (Object)this.getName());
            res.addChild((Resource)field);
            AbstractResourceImpl items = this.generateItemsResource(this.getPath() + FIELD_PATH, true);
            field.addChild((Resource)items);
        } else {
            for (FieldComponent component : this.fieldComponents.values()) {
                component.setPath(this.getPath() + FIELD_PATH);
                component.getComponentMetadata().putAll((Map)this.getComponentMetadata());
                Resource comp = component.buildComponentResource();
                comp.getResourceMetadata().put("name", (Object)this.getName());
                res.addChild(comp);
            }
        }
        return res;
    }
}

