/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.AbstractGroupingContainerComponent;
import com.adobe.acs.commons.mcp.form.AbstractResourceImpl;
import com.adobe.acs.commons.mcp.form.DialogProvider;
import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.form.FieldsetComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import com.adobe.acs.commons.mcp.util.AccessibleObjectUtil;
import com.adobe.acs.commons.mcp.util.AnnotatedFieldDeserializer;
import com.adobe.acs.commons.mcp.util.SyntheticResourceBuilder;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.ResourceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractContainerComponent
extends FieldComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContainerComponent.class);
    Map<String, FieldComponent> fieldComponents = new LinkedHashMap<String, FieldComponent>();
    private boolean composite;
    private AbstractGroupingContainerComponent groupingContainer;
    private Class<? extends FieldComponent> defaultChildComponent = TextfieldComponent.class;
    private DialogProvider.DialogStyle dialogStyle = DialogProvider.DialogStyle.UNKNOWN;
    private String propertiesTabName = null;
    private boolean forceDotSlashPrefix = true;

    public void applyDialogProviderSettings(DialogProvider providerAnnotation) {
        this.setDialogStyle(providerAnnotation.style());
        this.setPropertiesTabName(providerAnnotation.propertiesTab());
        this.setForceDotSlashPrefix(providerAnnotation.forceDotSlashPrefix());
        if (this.groupingContainer != null) {
            this.groupingContainer.applyDialogProviderSettings(providerAnnotation);
        }
    }

    @Override
    public void init() {
        if (this.getAccessibleObject() != null) {
            Class<?> fieldType = AccessibleObjectUtil.getType(this.getAccessibleObject());
            if (fieldType.isArray()) {
                this.extractFieldComponents(fieldType.getComponentType());
            } else if (Collection.class.isAssignableFrom(fieldType)) {
                ParameterizedType type = (ParameterizedType)AccessibleObjectUtil.getGenericType(this.getAccessibleObject());
                Class clazz = (Class)type.getActualTypeArguments()[0];
                this.extractFieldComponents(clazz);
            } else {
                this.extractFieldComponents(fieldType);
                this.fieldComponents.values().forEach(comp -> {
                    ResourceMetadata meta = comp.getComponentMetadata();
                    String currentName = String.valueOf(meta.get((Object)"name"));
                    meta.put("name", (Object)(AccessibleObjectUtil.getFieldName(this.getAccessibleObject()) + "/" + currentName));
                });
            }
        }
        if (this.getHelper() != null) {
            this.setPath(this.getHelper().getRequest().getResource().getPath());
        }
    }

    public AbstractGroupingContainerComponent getGroupingContainer() {
        if (this.groupingContainer == null) {
            this.groupingContainer = new AbstractGroupingContainerComponent.AccordionComponent();
        }
        return this.groupingContainer;
    }

    public void setGroupingContainer(AbstractGroupingContainerComponent comp) {
        this.groupingContainer = comp;
    }

    public Map<String, FieldComponent> getFieldComponents() {
        return this.fieldComponents;
    }

    public FieldComponent generateDefaultChildComponent() {
        try {
            return this.defaultChildComponent.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            LOG.error("got exception", (Throwable)ex);
            return null;
        }
    }

    private void extractFieldComponents(Class clazz) {
        if (clazz == String.class || clazz.isPrimitive()) {
            FieldComponent comp = this.generateDefaultChildComponent();
            FormField fieldDef = FormField.Factory.create(this.getName(), "", null, null, false, comp.getClass(), null, false, null);
            comp.setup(this.getName(), null, fieldDef, this.getHelper());
            comp.getComponentMetadata().put("title", (Object)this.getName());
            this.addComponent(this.getName(), comp);
            this.composite = false;
        } else {
            AnnotatedFieldDeserializer.getFormFields(clazz, this.getHelper()).forEach((name, component) -> this.addComponent((String)name, (FieldComponent)component));
            this.composite = true;
        }
        this.fieldComponents.values().forEach(this::addClientLibraries);
    }

    public void addComponent(String name, FieldComponent field) {
        this.fieldComponents.put(name, field);
        this.addClientLibraries(field);
    }

    protected AbstractResourceImpl generateItemsResource(String path, boolean useFieldSet) {
        SyntheticResourceBuilder rb = new SyntheticResourceBuilder(path + "/items", null);
        if (this.hasCategories(this.fieldComponents.values())) {
            AbstractGroupingContainerComponent groups = this.getGroupingContainer();
            groups.setPath(path + "/tabs");
            this.fieldComponents.forEach((name, component) -> groups.addComponent(component.getCategory(), (String)name, (FieldComponent)component));
            rb.withChild(groups.buildComponentResource());
        } else if (useFieldSet) {
            FieldsetComponent fieldset = new FieldsetComponent();
            this.fieldComponents.forEach((name, comp) -> fieldset.addComponent((String)name, (FieldComponent)comp));
            fieldset.setPath(path + "/fields");
            fieldset.setHelper(this.getHelper());
            rb.withChild(fieldset.buildComponentResource());
        } else {
            for (FieldComponent component2 : this.fieldComponents.values()) {
                if (this.getHelper() != null) {
                    component2.setHelper(this.getHelper());
                }
                component2.setPath(path + "/items/" + component2.getName());
                rb.withChild(component2.buildComponentResource());
            }
        }
        AbstractResourceImpl items = rb.build();
        if (this.getHelper() != null) {
            items.setResourceResolver(this.getHelper().getRequest().getResourceResolver());
        }
        return items;
    }

    public void setComposite(boolean val) {
        this.composite = val;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public boolean hasCategories(Collection<FieldComponent> values) {
        return values.stream().map(FieldComponent::getCategory).filter(s -> s != null && !s.isEmpty()).distinct().count() > 1L;
    }

    public void setDefaultChildComponent(Class<? extends FieldComponent> defaultChildComponent) {
        this.defaultChildComponent = defaultChildComponent;
    }

    public DialogProvider.DialogStyle getDialogStyle() {
        return this.dialogStyle;
    }

    public void setDialogStyle(DialogProvider.DialogStyle dialogStyle) {
        this.dialogStyle = dialogStyle;
    }

    public String getPropertiesTabName() {
        return this.propertiesTabName;
    }

    public void setPropertiesTabName(String propertiesTabName) {
        this.propertiesTabName = propertiesTabName;
    }

    public boolean isForceDotSlashPrefix() {
        return this.forceDotSlashPrefix;
    }

    public void setForceDotSlashPrefix(boolean forceDotSlashPrefix) {
        this.forceDotSlashPrefix = forceDotSlashPrefix;
    }
}

