/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp;

import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessDefinitionFactory;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class AuthorizedGroupProcessDefinitionFactory<P extends ProcessDefinition>
extends ProcessDefinitionFactory<P> {
    @Override
    public boolean isAllowed(User user) {
        try {
            return user.isAdmin() || StreamSupport.stream(Spliterators.spliteratorUnknownSize(user.memberOf(), 16), false).anyMatch(g -> {
                try {
                    for (String group : this.getAuthorizedGroups()) {
                        if (!g.getID().equals(group)) continue;
                        return true;
                    }
                    return false;
                }
                catch (RepositoryException ex) {
                    return false;
                }
            });
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected abstract String[] getAuthorizedGroups();

    @Override
    protected abstract P createProcessDefinitionInstance();
}

