/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.impl;

import com.adobe.acs.commons.indesign.dynamicdeckdynamo.exception.DynamicDeckDynamoException;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.XMLGeneratorService;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.DynamicDeckUtils;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.XMLResourceIterator;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component(service={XMLGeneratorService.class})
public class XMLGeneratorServiceImpl
implements XMLGeneratorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLGeneratorServiceImpl.class);

    @Override
    public String generateInddXML(InputStream xmlInputStream, List<XMLResourceIterator> assetItrList, Resource masterResource, Resource deckResource, ResourceResolver resourceResolver, List<String> imageList) throws DynamicDeckDynamoException {
        Asset processXmlAsset;
        block30: {
            InputStream processedXmlInputStream = null;
            File processedXmlTempFile = null;
            processXmlAsset = null;
            String xmlName = "processedXml.xml";
            if (null == masterResource) {
                masterResource = deckResource;
            }
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                DocumentBuilder dBuilder = dbf.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlInputStream);
                if (doc.hasChildNodes()) {
                    this.populateDocNodes(doc, assetItrList, masterResource, imageList);
                }
                processedXmlTempFile = File.createTempFile("targetFile-" + Calendar.getInstance().getTimeInMillis() + ".tmp", null);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(processedXmlTempFile);
                transformer.transform(domSource, result);
                processedXmlInputStream = new FileInputStream(processedXmlTempFile);
                Resource subassetsFolderResource = resourceResolver.getResource(DynamicDeckUtils.getOrCreateFolder(resourceResolver, "subassets", deckResource));
                if (null != subassetsFolderResource) {
                    AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
                    if (assetManager == null) {
                        throw new DynamicDeckDynamoException("Asset manager is null");
                    }
                    processXmlAsset = assetManager.createAsset(subassetsFolderResource.getPath() + "/" + "processedXml.xml", processedXmlInputStream, "text/xml", true);
                    LOGGER.debug("XML stored at {}", (Object)processXmlAsset.getPath());
                    break block30;
                }
                throw new DynamicDeckDynamoException("Asset subfolder is null, where processed xml asset needs to be created " + deckResource.getPath());
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new DynamicDeckDynamoException("Error while generation of xml", e);
            }
            finally {
                try {
                    Files.deleteIfExists(processedXmlTempFile.toPath());
                }
                catch (IOException e) {
                    LOGGER.error("Exception occurred while deleting the temp file", (Throwable)e);
                }
                if (null != processedXmlInputStream) {
                    try {
                        processedXmlInputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Exception occurred while closing the processed xml inputstream", (Throwable)e);
                    }
                }
            }
        }
        return processXmlAsset == null ? null : processXmlAsset.getPath();
    }

    private void populateDocNodes(Document doc, List<XMLResourceIterator> assetItrList, Resource masterResource, List<String> imageList) {
        this.populateHeaderValues(doc, masterResource, imageList);
        this.populateIterableValues(doc, assetItrList, imageList);
    }

    private void populateIterableValues(Document doc, List<XMLResourceIterator> assetItrList, List<String> imageList) {
        NodeList documentChildren = doc.getChildNodes();
        ArrayList<Node> iterableSections = new ArrayList<Node>();
        this.findSections(documentChildren, "iterable", iterableSections);
        HashMap<String, List<Node>> iterableSectionTypes = new HashMap<String, List<Node>>();
        this.segregateSections(iterableSections, iterableSectionTypes);
        for (XMLResourceIterator assetItr : assetItrList) {
            String itrType = assetItr.getKey();
            if (!iterableSectionTypes.containsKey(itrType)) continue;
            ListIterator<Resource> assetsIterator = assetItr.getIterator();
            List iterablesList = (List)iterableSectionTypes.get(itrType);
            assetsIterator.forEachRemaining(assetResource -> {
                ValueMap assetProperties = assetResource.getValueMap();
                for (Node node : iterablesList) {
                    this.duplicateNodeAndSetValues(node, assetProperties, (Resource)assetResource, imageList);
                }
            });
            for (Node node : iterablesList) {
                node.getParentNode().removeChild(node);
            }
        }
    }

    private void populateHeaderValues(Document doc, Resource masterResource, List<String> imageList) {
        NodeList documentChildren = doc.getChildNodes();
        ValueMap masterResourceValueMap = masterResource.getValueMap();
        ArrayList<Node> headerSections = new ArrayList<Node>();
        this.findSections(documentChildren, "master", headerSections);
        headerSections.listIterator().forEachRemaining(section -> this.populateMasterAssetPaths((Node)section, masterResource));
        headerSections.listIterator().forEachRemaining(section -> this.processSection(masterResource, masterResourceValueMap, (Node)section, imageList));
    }

    private void populateMasterAssetPaths(Node section, Resource masterResource) {
        Node assetPath;
        Node node = assetPath = section.hasAttributes() ? section.getAttributes().getNamedItem("asset-path") : null;
        if (assetPath != null) {
            assetPath.setNodeValue(masterResource.getPath());
        }
    }

    private void processSection(Resource assetResource, ValueMap assetProperties, Node section, List<String> imageList) {
        NodeList sectionChildren = section.getChildNodes();
        block8: for (int i = 0; i < sectionChildren.getLength(); ++i) {
            Node propertyType;
            Node childElement = sectionChildren.item(i);
            Node node = propertyType = childElement.hasAttributes() ? childElement.getAttributes().getNamedItem("field-type") : null;
            if (propertyType == null) continue;
            switch (propertyType.getNodeValue()) {
                case "image": {
                    this.populateImageProperty(assetProperties, childElement, assetResource.getPath(), imageList, assetResource.getResourceResolver());
                    continue block8;
                }
                case "text": {
                    this.populateTextProperty(assetProperties, childElement, assetResource.getPath());
                    continue block8;
                }
            }
        }
    }

    private void duplicateNodeAndSetValues(Node node, ValueMap assetProperties, Resource assetResource, List<String> imageList) {
        if (assetResource != null) {
            Node assetPath;
            Node nodeCopy = node.cloneNode(true);
            Node node2 = assetPath = nodeCopy.hasAttributes() ? nodeCopy.getAttributes().getNamedItem("asset-path") : null;
            if (assetPath != null) {
                assetPath.setNodeValue(assetResource.getPath());
            }
            this.processSection(assetResource, assetProperties, nodeCopy, imageList);
            node.getParentNode().appendChild(nodeCopy);
        }
    }

    private String processPropertyPath(ValueMap assetProperties, Node childElement, String assetPath) {
        Node propertyPathAttr = childElement.hasAttributes() ? childElement.getAttributes().getNamedItem("property-path") : null;
        String propertyValue = null;
        if (propertyPathAttr != null) {
            String propertyPath = propertyPathAttr.getNodeValue();
            String metadataProperty = "jcr:content/metadata/" + propertyPath;
            if (StringUtils.equals((CharSequence)propertyPath, (CharSequence)"_SELF_")) {
                propertyValue = assetPath;
            } else {
                Node isArrayAttr;
                Node node = isArrayAttr = childElement.hasAttributes() ? childElement.getAttributes().getNamedItem("is-array") : null;
                propertyValue = isArrayAttr != null && StringUtils.equals((CharSequence)isArrayAttr.getNodeValue(), (CharSequence)"true") ? (assetProperties.containsKey((Object)metadataProperty) ? this.getArrayValue(assetProperties, metadataProperty) : this.getArrayValue(assetProperties, propertyPath)) : (assetProperties.containsKey((Object)metadataProperty) ? (String)assetProperties.get(metadataProperty, String.class) : (String)assetProperties.get(propertyPath, String.class));
            }
        }
        return propertyValue;
    }

    private String getArrayValue(ValueMap assetProperties, String propertyPath) {
        int index;
        String propertyValue = null;
        String indexValue = StringUtils.substringBetween((String)propertyPath, (String)"[", (String)"]");
        String[] propertyValueArray = (String[])assetProperties.get(propertyPath = StringUtils.substringBeforeLast((String)propertyPath, (String)"["), String[].class);
        if (propertyValueArray != null && StringUtils.isNumeric((CharSequence)indexValue) && (index = Integer.parseInt(indexValue)) < propertyValueArray.length) {
            propertyValue = propertyValueArray[index];
        }
        return propertyValue;
    }

    private void populateTextProperty(ValueMap assetProperties, Node childElement, String assetPath) {
        String propertyValue = this.processPropertyPath(assetProperties, childElement, assetPath);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            childElement.setTextContent(propertyValue);
        }
    }

    private void populateImageProperty(ValueMap assetProperties, Node childElement, String assetPath, List<String> imageList, ResourceResolver resourceResolver) {
        Resource assetResource;
        String propertyValue = this.processPropertyPath(assetProperties, childElement, assetPath);
        if (StringUtils.isNotBlank((CharSequence)propertyValue) && DamUtil.isAsset((Resource)(assetResource = resourceResolver.getResource(propertyValue)))) {
            ((Element)childElement).setAttribute("href", "file:///" + StringUtils.substringAfterLast((String)propertyValue, (String)"/"));
            if (!this.isImageAdded(imageList, assetResource)) {
                imageList.add(assetResource.getPath());
            }
        }
    }

    private boolean isImageAdded(List<String> imageList, Resource assetResource) {
        String assetName = assetResource.getName();
        for (String path : imageList) {
            if (!StringUtils.equals((CharSequence)StringUtils.substringAfterLast((String)path, (String)"/"), (CharSequence)assetName)) continue;
            return true;
        }
        return false;
    }

    private void segregateSections(List<Node> iterableSections, Map<String, List<Node>> iterableSectionTypes) {
        for (Node section : iterableSections) {
            Node itrSecs = section.hasAttributes() ? section.getAttributes().getNamedItem("iterable-type") : null;
            if (itrSecs == null) continue;
            String itrType = itrSecs.getNodeValue();
            List<Object> itrTypesList = !iterableSectionTypes.containsKey(itrType) ? new ArrayList() : iterableSectionTypes.get(itrType);
            itrTypesList.add(section);
            iterableSectionTypes.put(itrType, itrTypesList);
        }
    }

    private void findSections(NodeList nodeList, String type, List<Node> sectionList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node secType;
            Node childNode = nodeList.item(i);
            Node node = secType = childNode.hasAttributes() ? childNode.getAttributes().getNamedItem("section-type") : null;
            if (secType != null && secType.getNodeValue().equals(type)) {
                sectionList.add(childNode);
                continue;
            }
            this.findSections(childNode.getChildNodes(), type, sectionList);
        }
    }
}

