/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.injectors;

import com.adobe.acs.commons.util.BufferedHttpServletResponse;
import com.adobe.acs.commons.util.BufferedServletOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Deactivate;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHtmlRequestInjector
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractHtmlRequestInjector.class);
    private ServiceRegistration filterRegistration;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.accepts(servletRequest, servletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try (BufferedHttpServletResponse originalResponse = new BufferedHttpServletResponse(response, new StringWriter(), null);){
            int injectionIndex;
            String originalContents;
            filterChain.doFilter((ServletRequest)request, (ServletResponse)originalResponse);
            String string = originalContents = originalResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.WRITER ? originalResponse.getBufferedServletOutput().getBufferedString() : null;
            if (originalContents != null && StringUtils.contains((String)response.getContentType(), (String)"html") && (injectionIndex = this.getInjectIndex(originalContents)) != -1) {
                originalResponse.setFlushBufferOnClose(false);
                PrintWriter printWriter = response.getWriter();
                printWriter.write(originalContents.substring(0, injectionIndex));
                this.inject(request, response, printWriter);
                printWriter.write(originalContents.substring(injectionIndex));
                return;
            }
        }
    }

    protected abstract void inject(HttpServletRequest var1, HttpServletResponse var2, PrintWriter var3);

    protected abstract int getInjectIndex(String var1);

    public void destroy() {
    }

    protected boolean accepts(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!StringUtils.equalsIgnoreCase((String)"get", (String)request.getMethod())) {
            return false;
        }
        if (StringUtils.equals((String)request.getHeader("X-Requested-With"), (String)"XMLHttpRequest")) {
            return false;
        }
        if (StringUtils.contains((String)request.getPathInfo(), (String)".") && !StringUtils.contains((String)request.getPathInfo(), (String)".html")) {
            return false;
        }
        if (StringUtils.endsWith((String)request.getHeader("Referer"), (String)("/editor.html" + request.getRequestURI()))) {
            return false;
        }
        if (StringUtils.endsWith((String)request.getHeader("Referer"), (String)"/cf")) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("Injecting HTML via AbstractHTMLRequestInjector");
        }
        return true;
    }

    protected final void registerAsFilter(ComponentContext ctx, int ranking, String pattern) {
        Hashtable<String, String> filterProps = new Hashtable<String, String>();
        ((Dictionary)filterProps).put("service.ranking", String.valueOf(ranking));
        ((Dictionary)filterProps).put("osgi.http.whiteboard.filter.regex", StringUtils.defaultIfEmpty((String)pattern, (String)".*"));
        ((Dictionary)filterProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
        this.filterRegistration = ctx.getBundleContext().registerService(Filter.class.getName(), (Object)this, filterProps);
    }

    protected final void registerAsSlingFilter(ComponentContext ctx, int ranking, String pattern) {
        Hashtable<String, String> filterProps = new Hashtable<String, String>();
        ((Dictionary)filterProps).put("service.ranking", String.valueOf(ranking));
        ((Dictionary)filterProps).put("sling.filter.scope", "REQUEST");
        ((Dictionary)filterProps).put("sling.filter.pattern", StringUtils.defaultIfEmpty((String)pattern, (String)".*"));
        this.filterRegistration = ctx.getBundleContext().registerService(Filter.class.getName(), (Object)this, filterProps);
    }

    protected final void unregisterFilter() {
        if (this.filterRegistration != null) {
            this.filterRegistration.unregister();
            this.filterRegistration = null;
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        this.unregisterFilter();
    }
}

