/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.hc.impl;

import com.adobe.acs.commons.util.RequireAem;
import com.day.cq.commons.mail.MailTemplate;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Health Check - SMTP E-Mail Service", description="Checks if the AEM E-Mail Service can connect and send mail via the configured SMTP server.", policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="hc.name", value={"SMTP Mail Service"}, propertyPrivate=true), @Property(label="Tags", name="hc.tags", unbounded=PropertyUnbounded.ARRAY, value={"integrations", "smtp", "email"}, description="Tags for this check to be used by composite health checks."), @Property(name="hc.mbean.name", value={"smtpMailService"}, propertyPrivate=true)})
@Service
public class SMTPMailServiceHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(SMTPMailServiceHealthCheck.class);
    private static final int TIMEOUT = 10000;
    private static String MAIL_TEMPLATE = System.getProperty("line.separator") + "Sling Health Check for AEM E-mail Service connectivity";
    private static final String DEFAULT_EMAIL = "healthcheck@example.com";
    @Property(label="Test E-mail Address", description="E-mail address to send test message to.", value={"healthcheck@example.com"})
    private static final String PROP_EMAIL = "email";
    private String toEmail;
    private static final int DEFAULT_MAX_EMAILS_PER_DAY = 24;
    @Property(label="Maximum e-mails pings per day", description="Maximum number of e-mail pings this service attempts per day. Once this limit is met, this service will wait until tomorrow, or until this service is", intValue={24})
    private static final String PROP_MAX_EMAILS_PER_DAY = "max.emails.per.day";
    private int maxEmailsPerDay = 24;
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    private MessageGatewayService messageGatewayService;
    private transient ConcurrentHashMap<String, Integer> tracker = new ConcurrentHashMap();

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.toEmail = PropertiesUtil.toString((Object)properties.get(PROP_EMAIL), (String)DEFAULT_EMAIL);
        this.maxEmailsPerDay = PropertiesUtil.toInteger((Object)properties.get(PROP_MAX_EMAILS_PER_DAY), (int)24);
    }

    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        if (this.messageGatewayService == null) {
            resultLog.critical("MessageGatewayService OSGi service could not be found.", new Object[0]);
            resultLog.info("Verify the Default Mail Service is active: http://<host>:<port>/system/console/components/com.day.cq.mailer.impl.CqMailingService", new Object[0]);
        } else {
            MessageGateway messageGateway = this.messageGatewayService.getGateway(SimpleEmail.class);
            if (messageGateway == null) {
                resultLog.critical("The AEM Default Mail Service is INACTIVE, thus e-mails cannot be sent.", new Object[0]);
                resultLog.info("Verify the Default Mail Service is active and configured: http://<host>:<port>/system/console/components/com.day.cq.mailer.DefaultMailService", new Object[0]);
                log.warn("Could not retrieve a SimpleEmail Message Gateway");
            } else if (StringUtils.equals((CharSequence)this.toEmail, (CharSequence)DEFAULT_EMAIL)) {
                resultLog.warn("The default e-mail address [ " + this.toEmail + "] is configured, which no one can verify (since you don't own @example.com). Please set this to a valid e-mail address is configured that can handle the rate of e-mails you will be sending.", new Object[0]);
                log.warn("Default e-mail address [ {} ] used. Skipping sending e-mail as it cannot be verified on the other end. Please set a valid e-mail address via OSGi configuration, and ensure you performing this healthcheck at a reasonable rate so as not to flood your SMTP server or e-mail inbox.", (Object)DEFAULT_EMAIL);
            } else if (this.getEmailsSentToday() > this.maxEmailsPerDay) {
                resultLog.warn("Max quota for e-mails sent from this service per day [ " + this.maxEmailsPerDay + " ] has been met. Skipping sending further e-mail pings until tomorrow.", new Object[0]);
                log.warn("Max quota for e-mails sent from this service per day [ {} ] has been met. Skipping sending further e-mail pings until tomorrow.", (Object)this.maxEmailsPerDay);
            } else {
                try {
                    ArrayList<InternetAddress> emailAddresses = new ArrayList<InternetAddress>();
                    emailAddresses.add(new InternetAddress(this.toEmail));
                    MailTemplate mailTemplate = new MailTemplate(IOUtils.toInputStream((String)MAIL_TEMPLATE, (String)"UTF-8"), "UTF-8");
                    SimpleEmail email = (SimpleEmail)mailTemplate.getEmail(StrLookup.mapLookup(Collections.emptyMap()), SimpleEmail.class);
                    email.setSubject("AEM E-mail Service Health Check");
                    email.setTo(emailAddresses);
                    email.setSocketConnectionTimeout(10000);
                    email.setSocketTimeout(10000);
                    try {
                        messageGateway.send((Object)email);
                        resultLog.info("The E-mail Service appears to be working properly. Verify the health check e-mail was sent to [ {} ]", new Object[]{this.toEmail});
                    }
                    catch (Exception e) {
                        resultLog.critical("Failed sending e-mail. Unable to send a test toEmail via the configured E-mail server: " + e.getMessage(), new Object[]{e});
                        log.warn("Failed to send E-mail for E-mail Service health check", (Throwable)e);
                    }
                    this.logMailServiceConfig(resultLog, email);
                }
                catch (Exception e) {
                    resultLog.healthCheckError("Sling Health check could not formulate a test toEmail: " + e.getMessage(), new Object[]{e});
                    log.error("Unable to execute E-mail health check", (Throwable)e);
                }
            }
        }
        return new Result((ResultLog)resultLog);
    }

    private synchronized int getEmailsSentToday() {
        Calendar now = Calendar.getInstance();
        String key = now.get(1) + "-" + now.get(2) + "-" + now.get(5);
        if (this.tracker.containsKey(key)) {
            this.tracker.put(key, this.tracker.get(key) + 1);
        } else {
            this.tracker.clear();
            this.tracker.put(key, 1);
        }
        return this.tracker.get(key);
    }

    private void logMailServiceConfig(FormattingResultLog resultLog, SimpleEmail email) {
        resultLog.info("SMTP Host: {}", new Object[]{email.getHostName()});
        resultLog.info("SMTP use SSL: {}", new Object[]{email.isSSL()});
        if (email.isSSL()) {
            resultLog.info("SMTP SSL Port: {}", new Object[]{email.getSslSmtpPort()});
        } else {
            resultLog.info("SMTP Port: {}", new Object[]{email.getSmtpPort()});
        }
        resultLog.info("SMTP From Address: {}", new Object[]{email.getFromAddress()});
        resultLog.info("Socket Connection Timeout: {} seconds", new Object[]{email.getSocketConnectionTimeout() / 1000});
        resultLog.info("Socket IO Timeout: {} seconds", new Object[]{email.getSocketTimeout() / 1000});
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }
}

