/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.cloudconfig.impl;

import com.adobe.acs.commons.cloudconfig.CloudConfiguration;
import com.adobe.acs.commons.cloudconfig.CloudConfigurationList;
import com.drew.lang.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={CloudConfigurationList.class})
public class CloudConfigurationListImpl
implements CloudConfigurationList {
    private static final Logger log = LoggerFactory.getLogger(CloudConfigurationListImpl.class);
    private List<CloudConfiguration> configs = new ArrayList<CloudConfiguration>();

    public CloudConfigurationListImpl(SlingHttpServletRequest slingRequest) {
        String template = Optional.ofNullable(slingRequest.getRequestPathInfo().getSuffix()).orElse("");
        if (StringUtils.isNotBlank((CharSequence)template)) {
            String query = "SELECT * FROM [cq:Page] WHERE ISDESCENDANTNODE([/conf]) AND [jcr:content/cq:template]='" + template.replace("'", "''") + "'";
            log.debug("Finding cloud configuerations with: {}", (Object)query);
            slingRequest.getResourceResolver().findResources(query, "JCR-SQL2").forEachRemaining(ccr -> this.configs.add((CloudConfiguration)ccr.adaptTo(CloudConfiguration.class)));
        } else {
            log.debug("Suffix not specified");
        }
    }

    @Override
    @NotNull
    public List<CloudConfiguration> getCloudConfigurations() {
        return Collections.unmodifiableList(this.configs);
    }
}

