/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl.options;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.util.InfoWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class AbstractChecksumGeneratorOptions
implements ChecksumGeneratorOptions {
    protected Set<String> includedNodeTypes = new HashSet<String>();
    protected Set<String> excludedNodeTypes = new HashSet<String>();
    protected Set<String> excludedProperties = new HashSet<String>();
    protected Set<String> sortedProperties = new HashSet<String>();
    protected Set<String> excludedNodeNames = new HashSet<String>();
    protected Set<String> excludedSubTrees = new HashSet<String>();

    public void addIncludedNodeTypes(String ... data) {
        if (data != null) {
            this.includedNodeTypes.addAll(Arrays.asList(data));
        }
    }

    @Override
    public Set<String> getIncludedNodeTypes() {
        return this.includedNodeTypes;
    }

    public void addExcludedNodeTypes(String ... data) {
        if (data != null) {
            this.excludedNodeTypes.addAll(Arrays.asList(data));
        }
    }

    @Override
    public Set<String> getExcludedNodeTypes() {
        return this.excludedNodeTypes;
    }

    public void addExcludedProperties(String ... data) {
        if (data != null) {
            this.excludedProperties.addAll(Arrays.asList(data));
        }
    }

    @Override
    public Set<String> getExcludedProperties() {
        return this.excludedProperties;
    }

    public void addSortedProperties(String ... data) {
        if (data != null) {
            this.sortedProperties.addAll(Arrays.asList(data));
        }
    }

    @Override
    public Set<String> getSortedProperties() {
        return this.sortedProperties;
    }

    @Override
    public Set<String> getExcludedNodeNames() {
        return this.excludedNodeNames;
    }

    public void addExcludedNodeNames(String ... data) {
        if (data != null) {
            this.excludedNodeNames.addAll(Arrays.asList(data));
        }
    }

    @Override
    public Set<String> getExcludedSubTrees() {
        return this.excludedSubTrees;
    }

    public void addExcludedSubTrees(String ... data) {
        if (data != null) {
            this.excludedSubTrees.addAll(Arrays.asList(data));
        }
    }

    public String toString() {
        InfoWriter iw = new InfoWriter();
        iw.title("Checksum Generator Options");
        iw.message("Node Type Includes: {}", this.getIncludedNodeTypes());
        iw.message("Node Type Excludes: {}", this.getExcludedNodeTypes());
        iw.message("Property Excludes: {}", this.getExcludedProperties());
        iw.message("Node Name Excludes: {}", this.getExcludedNodeNames());
        iw.message("Sub Tree Excludes: {}", this.getExcludedSubTrees());
        iw.message("Sorted Properties: {}", this.getSortedProperties());
        return iw.toString();
    }
}

