/*
 * Decompiled with CFR 0.152.
 */
package acscommons.io.jsonwebtoken.impl.compression;

import acscommons.io.jsonwebtoken.CompressionCodec;
import acscommons.io.jsonwebtoken.CompressionCodecResolver;
import acscommons.io.jsonwebtoken.CompressionCodecs;
import acscommons.io.jsonwebtoken.CompressionException;
import acscommons.io.jsonwebtoken.Header;
import acscommons.io.jsonwebtoken.impl.lang.Services;
import acscommons.io.jsonwebtoken.lang.Assert;
import acscommons.io.jsonwebtoken.lang.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    private static final String MISSING_COMPRESSION_MESSAGE = "Unable to find an implementation for compression algorithm [%s] using java.util.ServiceLoader. Ensure you include a backing implementation .jar in the classpath, for example jjwt-impl.jar, or your own .jar for custom implementations.";
    private final Map<String, CompressionCodec> codecs;

    public DefaultCompressionCodecResolver() {
        HashMap<String, CompressionCodec> codecMap = new HashMap<String, CompressionCodec>();
        for (CompressionCodec codec : Services.loadAll(CompressionCodec.class)) {
            codecMap.put(codec.getAlgorithmName().toUpperCase(), codec);
        }
        codecMap.put(CompressionCodecs.DEFLATE.getAlgorithmName().toUpperCase(), CompressionCodecs.DEFLATE);
        codecMap.put(CompressionCodecs.GZIP.getAlgorithmName().toUpperCase(), CompressionCodecs.GZIP);
        this.codecs = Collections.unmodifiableMap(codecMap);
    }

    @Override
    public CompressionCodec resolveCompressionCodec(Header header) {
        String cmpAlg = this.getAlgorithmFromHeader(header);
        boolean hasCompressionAlgorithm = Strings.hasText(cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        return this.byName(cmpAlg);
    }

    private String getAlgorithmFromHeader(Header header) {
        Assert.notNull(header, "header cannot be null.");
        return header.getCompressionAlgorithm();
    }

    private CompressionCodec byName(String name) {
        Assert.hasText(name, "'name' must not be empty");
        CompressionCodec codec = this.codecs.get(name.toUpperCase());
        if (codec == null) {
            throw new CompressionException(String.format(MISSING_COMPRESSION_MESSAGE, name));
        }
        return codec;
    }
}

