/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.endpoints;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class EndpointBase<RequestT, ResponseT>
implements Endpoint<RequestT, ResponseT, ErrorResponse> {
    private static final Function<?, Map<String, String>> EMPTY_MAP = x -> Collections.emptyMap();
    private static final Function<?, Object> RETURN_NULL = x -> null;
    private static final Function<?, ?> RETURN_SELF = x -> x;
    protected final String id;
    protected final Function<RequestT, String> method;
    protected final Function<RequestT, String> requestUrl;
    protected final Function<RequestT, Map<String, String>> queryParameters;
    protected final Function<RequestT, Map<String, String>> headers;
    protected final Function<RequestT, Object> body;
    private static final BitSet PATH_SAFE = new BitSet(256);
    private static final char[] HEX_CHARS;

    public static <T> Function<T, Map<String, String>> emptyMap() {
        return EMPTY_MAP;
    }

    static <T, U> Function<T, U> returnNull() {
        return RETURN_NULL;
    }

    static <T, U> Function<T, U> returnSelf() {
        return RETURN_SELF;
    }

    public EndpointBase(String id, Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, Function<RequestT, Object> body) {
        this.id = id;
        this.method = method;
        this.requestUrl = requestUrl;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String method(RequestT request) {
        return this.method.apply(request);
    }

    @Override
    public String requestUrl(RequestT request) {
        return this.requestUrl.apply(request);
    }

    @Override
    public Map<String, String> queryParameters(RequestT request) {
        return this.queryParameters.apply(request);
    }

    @Override
    public Map<String, String> headers(RequestT request) {
        return this.headers.apply(request);
    }

    @Override
    @Nullable
    public Object body(RequestT request) {
        return this.body.apply(request);
    }

    @Override
    public boolean isError(int statusCode) {
        return statusCode >= 400;
    }

    @Override
    public JsonpDeserializer<ErrorResponse> errorDeserializer(int statusCode) {
        return ErrorResponse._DESERIALIZER;
    }

    public <NewResponseT> SimpleEndpoint<RequestT, NewResponseT> withResponseDeserializer(JsonpDeserializer<NewResponseT> newResponseParser) {
        return new SimpleEndpoint<RequestT, NewResponseT>(this.id, this.method, this.requestUrl, this.queryParameters, this.headers, this.body, newResponseParser);
    }

    public static RuntimeException noPathTemplateFound(String what) {
        return new RuntimeException("Could not find a request " + what + " with this set of properties. Please check the API documentation, or raise an issue if this should be a valid request.");
    }

    public static void pathEncode(String src, StringBuilder dest) {
        ByteBuffer buf = StandardCharsets.UTF_8.encode(src);
        while (buf.hasRemaining()) {
            int b = buf.get() & 0xFF;
            if (PATH_SAFE.get(b)) {
                dest.append((char)b);
                continue;
            }
            dest.append("%");
            dest.append(HEX_CHARS[b >> 4 & 0xF]);
            dest.append(HEX_CHARS[b & 0xF]);
        }
    }

    static {
        PATH_SAFE.set(97, 123);
        PATH_SAFE.set(65, 91);
        PATH_SAFE.set(48, 58);
        PATH_SAFE.set(45);
        PATH_SAFE.set(46);
        PATH_SAFE.set(95);
        PATH_SAFE.set(126);
        PATH_SAFE.set(33);
        PATH_SAFE.set(36);
        PATH_SAFE.set(38);
        PATH_SAFE.set(39);
        PATH_SAFE.set(40);
        PATH_SAFE.set(41);
        PATH_SAFE.set(42);
        PATH_SAFE.set(43);
        PATH_SAFE.set(44);
        PATH_SAFE.set(59);
        PATH_SAFE.set(61);
        PATH_SAFE.set(58);
        PATH_SAFE.set(64);
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
    }
}

