/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.DeleteSnapshotResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteSnapshotRequest
extends RequestBase {
    @Nullable
    private final Time masterTimeout;
    private final String repository;
    private final String snapshot;
    public static final Endpoint<DeleteSnapshotRequest, DeleteSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteSnapshotRequest, DeleteSnapshotResponse>("es/snapshot.delete", request -> "DELETE", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteSnapshotResponse._DESERIALIZER);

    private DeleteSnapshotRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
    }

    public static DeleteSnapshotRequest of(Function<Builder, ObjectBuilder<DeleteSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteSnapshotRequest> {
        @Nullable
        private Time masterTimeout;
        private String repository;
        private String snapshot;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteSnapshotRequest build() {
            this._checkSingleUse();
            return new DeleteSnapshotRequest(this);
        }
    }
}

