/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.remark;

import io.rong.RongCloud;
import io.rong.models.response.GetUserRemarksResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;

public class Remark {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/remark";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Remark(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public ResponseResult set(String userId, String remarks) throws Exception {
        String message = CommonUtil.checkParam("id", userId, PATH, "set");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&remarks=" + remarks);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/remarks/set.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "set", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult del(String userId, String targetId) throws Exception {
        String message = CommonUtil.checkParam("id", userId, PATH, "set");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&targetId=" + targetId);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/remarks/del.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "del", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public GetUserRemarksResult get(String userId, int page, int size) throws Exception {
        String message = CommonUtil.checkParam("id", userId, PATH, "set");
        if (null != message) {
            return (GetUserRemarksResult)GsonUtil.fromJson(message, GetUserRemarksResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=" + userId);
        sb.append("&page=" + page);
        sb.append("&size=" + size);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/remarks/get.json");
        HttpUtil.setBodyParameter(sb.toString(), conn, this.rongCloud.getConfig());
        return (GetUserRemarksResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GetUserRemarksResult.class);
    }

    public GetUserRemarksResult get(String userId) throws Exception {
        return this.get(userId, 1, 50);
    }

    public GetUserRemarksResult get(String userId, int page) throws Exception {
        return this.get(userId, page, 50);
    }
}

