/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.blockpushperiod;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.BlockPushPeriodResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.user.BlockPushPeriodModel;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class BlockPushPeriod {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/blockpushperiod";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public BlockPushPeriod(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public Result add(BlockPushPeriodModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=").append(URLEncoder.encode(user.getId(), UTF8));
        sb.append("&startTime=").append(URLEncoder.encode(user.getStartTime(), UTF8));
        sb.append("&period=").append(URLEncoder.encode(user.getPeriod().toString(), UTF8));
        sb.append("&level=").append(URLEncoder.encode(user.getLevel().toString(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blockPushPeriod/set.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public BlockPushPeriodResult getList(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "getList");
        if (null != message) {
            return (BlockPushPeriodResult)GsonUtil.fromJson(message, BlockPushPeriodResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=").append(URLEncoder.encode(user.getId(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blockPushPeriod/get.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (BlockPushPeriodResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), BlockPushPeriodResult.class);
    }

    public Result remove(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("userId=").append(URLEncoder.encode(user.getId(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blockPushPeriod/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }
}

