/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.push;

import com.alibaba.fastjson.JSONException;
import com.google.gson.JsonParseException;
import io.rong.RongCloud;
import io.rong.models.push.BroadcastModel;
import io.rong.models.push.PushModel;
import io.rong.models.response.PushResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;

public class Push {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "push";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Push(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public PushResult message(BroadcastModel broadcast) throws Exception {
        String message = CommonUtil.checkFiled(broadcast, PATH, "broadcast");
        if (null != message) {
            return (PushResult)GsonUtil.fromJson(message, PushResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/push.json", "application/json");
        HttpUtil.setBodyParameter(broadcast.toString(), conn, this.rongCloud.getConfig());
        return (PushResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "broadcast", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), PushResult.class);
    }

    public PushResult push(PushModel push) throws Exception {
        String message = CommonUtil.checkFiled(push, PATH, PATH);
        if (null != message) {
            return (PushResult)GsonUtil.fromJson(message, PushResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/push.json", "application/json");
        HttpUtil.setBodyParameter(push.toString(), conn, this.rongCloud.getConfig());
        PushResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (PushResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, PATH, response), PushResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new PushResult(500, "");
            result.setErrorMessage("request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(push.toString());
        return result;
    }
}

