/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.ultragroup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.google.gson.JsonParseException;
import io.rong.RongCloud;
import io.rong.models.message.RecallMessage;
import io.rong.models.message.UltraGroupMessage;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.concurrent.ConcurrentHashMap;

public class UltraGroup {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "message/ultragroup";
    private static final String RECAL_PATH = "message/recall";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public UltraGroup(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult send(UltraGroupMessage message) throws Exception {
        String code = CommonUtil.checkFiled(message, PATH, "send");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        ConcurrentHashMap<String, Object> params = new ConcurrentHashMap<String, Object>();
        params.put("fromUserId", message.getSenderId());
        params.put("toGroupIds", message.getTargetId());
        params.put("objectName", message.getObjectName());
        params.put("content", message.getContent().toString());
        if (message.getPushContent() != null) {
            params.put("pushContent", message.getPushContent().toString());
        }
        if (message.getPushData() != null) {
            params.put("pushData", message.getPushData());
        }
        if (message.getIsMentioned() != null) {
            params.put("isMentioned", message.getIsMentioned());
        }
        if (message.getPushExt() != null) {
            params.put("pushExt", message.getPushExt());
        }
        if (message.getIsPersisted() != null) {
            params.put("isPersisted", message.getIsPersisted());
        }
        if (message.getBusChannel() != null) {
            params.put("busChannel", message.getBusChannel());
        }
        if (message.getContentAvailable() != null) {
            params.put("contentAvailable", message.getContentAvailable());
        }
        if (message.getIsCounted() != null) {
            params.put("isCounted", message.getIsCounted());
        }
        if (message.getExpansion() != null && message.getExpansion().booleanValue()) {
            params.put("expansion", message.getExpansion());
            if (message.getExtraContent() != null) {
                params.put("extraContent", JSON.toJSONString(message.getExtraContent()));
            }
        }
        if (message.getMsgRandom() != null) {
            params.put("msgRandom", message.getMsgRandom());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/ultragroup/publish.json", "application/json");
        HttpUtil.setBodyParameter(GsonUtil.toJson(params), conn, this.rongCloud.getConfig());
        ResponseResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", response), ResponseResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new ResponseResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(GsonUtil.toJson(params));
        return result;
    }

    public ResponseResult recall(RecallMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, RECAL_PATH, "recall");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode("10", UTF8));
        sb.append("&fromUserId=").append(URLEncoder.encode(message.senderId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(message.targetId.toString(), UTF8));
        sb.append("&messageUID=").append(URLEncoder.encode(message.uId.toString(), UTF8));
        sb.append("&sentTime=").append(URLEncoder.encode(message.sentTime.toString(), UTF8));
        if (message.getIsAdmin() != null) {
            sb.append("&isAdmin=").append(URLEncoder.encode(message.getIsAdmin().toString(), UTF8));
        }
        if (message.getDisablePush() != null) {
            sb.append("&disablePush=").append(message.getDisablePush().toString());
        }
        if (message.getIsDelete() != null) {
            sb.append("&isDelete=").append(URLEncoder.encode(message.getIsDelete().toString(), UTF8));
        }
        if (message.getExtra() != null) {
            sb.append("&extra=").append(URLEncoder.encode(message.getExtra().toString(), UTF8));
        }
        if (message.getBusChannel() != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(message.getBusChannel().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/recall.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(RECAL_PATH, "recall", response), ResponseResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new ResponseResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }
}

