/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.group;

import io.rong.RongCloud;
import io.rong.methods.group.ban.Ban;
import io.rong.methods.group.gag.Gag;
import io.rong.methods.group.mute.MuteAllMembers;
import io.rong.methods.group.mute.MuteMembers;
import io.rong.methods.group.mute.whitelist.MuteWhiteList;
import io.rong.methods.group.remark.Remark;
import io.rong.models.Result;
import io.rong.models.group.GroupMember;
import io.rong.models.group.GroupMemberCount;
import io.rong.models.group.GroupModel;
import io.rong.models.group.UserGroup;
import io.rong.models.response.GroupUserQueryResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class Group {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "group";
    private String appKey;
    private String appSecret;
    public Gag gag;
    public Ban ban;
    public MuteAllMembers muteAllMembers;
    public MuteMembers muteMembers;
    public MuteWhiteList muteWhiteList;
    public Remark remark;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Group(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.gag = new Gag(appKey, appSecret, rongCloud);
        this.ban = new Ban(appKey, appSecret, rongCloud);
        this.muteAllMembers = new MuteAllMembers(appKey, appSecret, rongCloud);
        this.muteMembers = new MuteMembers(appKey, appSecret, rongCloud);
        this.muteWhiteList = new MuteWhiteList(appKey, appSecret, rongCloud);
        this.remark = new Remark(appKey, appSecret, rongCloud);
    }

    public Result create(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "create");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        sb = this.operateGroup(sb, group);
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (GroupMemberCount)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "create", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GroupMemberCount.class);
    }

    public Result sync(UserGroup user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "sync");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId(), UTF8));
        for (int i = 0; i < user.getGroups().length; ++i) {
            GroupModel child = user.getGroups()[i];
            if (child.getName() == null) {
                return new ResponseResult(1002, "Paramer 'group.name' is required");
            }
            if (child.getId() == null) {
                return new ResponseResult(1002, "Paramer 'group.id' is required");
            }
            sb.append("&group[" + child.getId() + "]=").append(URLEncoder.encode(child.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/sync.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sync", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result update(GroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "update");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        sb = this.operateGroup(sb, group);
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "update", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result invite(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "invite");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "invite", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result join(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "join");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        sb = this.operateGroup(sb, group);
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (GroupMemberCount)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "join", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GroupMemberCount.class);
    }

    public GroupUserQueryResult get(GroupModel group) throws Exception {
        String errMsg = CommonUtil.checkFiled(group, PATH, "get");
        if (null != errMsg) {
            return (GroupUserQueryResult)GsonUtil.fromJson(errMsg, GroupUserQueryResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (GroupUserQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GroupUserQueryResult.class);
    }

    public Result quit(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "quit");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb = this.operateGroup(sb, group);
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/quit.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "quit", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result dismiss(GroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "dismiss");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        GroupMember member = group.getMembers()[0];
        sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb = this.operateGroup(sb, group);
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/group/dismiss.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "dismiss", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    private StringBuilder operateGroup(StringBuilder sb, GroupModel group) {
        if (group.isBindNotifyMsg()) {
            sb.append("&bindNotifyMsg=").append(group.isBindNotifyMsg());
            sb.append("&maxMember=").append(group.getMaxMember());
            if (StringUtils.isNotBlank((CharSequence)group.getFromUserId())) {
                sb.append("&fromUserId=").append(group.getFromUserId());
            }
            if (StringUtils.isNotBlank((CharSequence)group.getObjectName())) {
                sb.append("&objectName=").append(group.getObjectName());
            }
            if (StringUtils.isNotBlank((CharSequence)group.getContent())) {
                sb.append("&content=").append(group.getContent());
            }
            if (StringUtils.isNotBlank((CharSequence)group.getPushContent())) {
                sb.append("&pushContent=").append(group.getPushContent());
            }
            if (StringUtils.isNotBlank((CharSequence)group.getPushData())) {
                sb.append("&pushData=").append(group.getPushData());
            }
            sb.append("&isIncludeSender=").append(group.getIsIncludeSender());
            sb.append("&isPersisted=").append(group.getIsPersisted());
            if (StringUtils.isNotBlank((CharSequence)group.getPushExt())) {
                sb.append("&pushExt=").append(group.getPushExt());
            }
        }
        return sb;
    }
}

