/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom;

import io.rong.RongCloud;
import io.rong.methods.chatroom.ban.Ban;
import io.rong.methods.chatroom.ban.BanAllMember;
import io.rong.methods.chatroom.ban.BanAllMemberWhitelist;
import io.rong.methods.chatroom.block.Block;
import io.rong.methods.chatroom.demotion.Demotion;
import io.rong.methods.chatroom.distribute.Distribute;
import io.rong.methods.chatroom.entry.ChatroomEntry;
import io.rong.methods.chatroom.gag.Gag;
import io.rong.methods.chatroom.keepalive.Keepalive;
import io.rong.methods.chatroom.mute.MuteMembers;
import io.rong.methods.chatroom.whitelist.Whitelist;
import io.rong.models.chatroom.ChatroomDataModel;
import io.rong.models.chatroom.ChatroomDestroyTypeModel;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.chatroom.ChatroomModel;
import io.rong.models.response.ChatroomQueryResult;
import io.rong.models.response.ChatroomUserQueryResult;
import io.rong.models.response.CheckChatRoomUserResult;
import io.rong.models.response.CheckChatRoomUsersResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Chatroom {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom";
    private String appKey;
    private String appSecret;
    public Block block;
    public Gag gag;
    public MuteMembers muteMembers;
    public Ban ban;
    public BanAllMember banAllMember;
    public BanAllMemberWhitelist banAllMemberWhitelist;
    public Keepalive keepalive;
    public Demotion demotion;
    public Whitelist whiteList;
    public Distribute distribute;
    public ChatroomEntry entry;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
        this.gag.setRongCloud(rongCloud);
        this.keepalive.setRongCloud(rongCloud);
        this.demotion.setRongCloud(rongCloud);
        this.whiteList.setRongCloud(rongCloud);
        this.block.setRongCloud(rongCloud);
        this.demotion.setRongCloud(rongCloud);
        this.distribute.setRongCloud(rongCloud);
        this.ban.setRongCloud(rongCloud);
        this.banAllMember.setRongCloud(rongCloud);
        this.banAllMemberWhitelist.setRongCloud(rongCloud);
        this.entry.setRongCloud(rongCloud);
    }

    public Chatroom(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.gag = new Gag(appKey, appSecret);
        this.keepalive = new Keepalive(appKey, appSecret);
        this.demotion = new Demotion(appKey, appSecret);
        this.whiteList = new Whitelist(appKey, appSecret);
        this.block = new Block(appKey, appSecret);
        this.distribute = new Distribute(appKey, appSecret);
        this.ban = new Ban(appKey, appSecret);
        this.banAllMember = new BanAllMember(appKey, appSecret);
        this.banAllMemberWhitelist = new BanAllMemberWhitelist(appKey, appSecret);
        this.muteMembers = new MuteMembers(appKey, appSecret, rongCloud);
        this.entry = new ChatroomEntry(appKey, appSecret);
    }

    @Deprecated
    public ResponseResult create(ChatroomModel[] chatrooms) throws Exception {
        if (chatrooms == null) {
            return new ResponseResult(1002, "Paramer 'chatrooms' is required");
        }
        for (ChatroomModel chatroom : chatrooms) {
            String message = CommonUtil.checkFiled(chatroom, PATH, "create");
            if (null == message) continue;
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chatrooms.length; ++i) {
            ChatroomModel chatroom = chatrooms[i];
            sb.append("&chatroom[" + chatroom.getId() + "]=").append(URLEncoder.encode(chatroom.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "create", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult createV2(ChatroomDataModel chatroom) throws Exception {
        String body;
        if (chatroom == null) {
            return new ResponseResult(1002, "Paramer 'chatrooms' is required");
        }
        String message = CommonUtil.checkFiled(chatroom, PATH, "createv2");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("chatroomId=").append(URLEncoder.encode(chatroom.getId().toString(), UTF8));
        if (null != chatroom.getDestroyType()) {
            sb.append("&destroyType=").append(URLEncoder.encode(chatroom.getDestroyType().toString(), UTF8));
        }
        if (null != chatroom.getDestroyTime()) {
            sb.append("&destroyTime=").append(URLEncoder.encode(chatroom.getDestroyTime().toString(), UTF8));
        }
        if (null != chatroom.getIsBan()) {
            sb.append("&isBan=").append(URLEncoder.encode(chatroom.getIsBan().toString(), UTF8));
        }
        if (null != chatroom.getEntryOwnerId()) {
            sb.append("&entryOwnerId=").append(URLEncoder.encode(chatroom.getEntryOwnerId().toString(), UTF8));
        }
        if (null != chatroom.getWhiteUserIds() && chatroom.getWhiteUserIds().length > 0) {
            for (String user : chatroom.getWhiteUserIds()) {
                sb.append("&whiteUserIds=").append(URLEncoder.encode(user, UTF8));
            }
        }
        if (null != chatroom.getEntryInfo() && chatroom.getEntryInfo().size() > 0) {
            sb.append("&entryInfo=").append(URLEncoder.encode(GsonUtil.toJson(chatroom.getEntryInfo()), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/create_new.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "createv2", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }

    public ResponseResult setDestroyType(ChatroomDestroyTypeModel destroyType) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(destroyType, PATH, "destory");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("chatroomId=").append(URLEncoder.encode(destroyType.getId().toString(), UTF8));
        if (null != destroyType.getDestroyType()) {
            sb.append("&destroyType=").append(URLEncoder.encode(destroyType.getDestroyType().toString(), UTF8));
        }
        if (null != destroyType.getDestroyTime()) {
            sb.append("&destroyTime=").append(URLEncoder.encode(destroyType.getDestroyTime().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/destroy/set.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "destory", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
        result.setReqBody(body);
        return result;
    }

    public ResponseResult destroy(ChatroomModel chatroom) throws Exception {
        String message = CommonUtil.checkFiled(chatroom, PATH, "destory");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        String body = "chatroomId=" + URLEncoder.encode(chatroom.getId(), UTF8);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/destroy.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "destory", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ChatroomUserQueryResult get(ChatroomModel chatroom) throws Exception {
        String message = CommonUtil.checkFiled(chatroom, PATH, "get");
        if (null != message) {
            return (ChatroomUserQueryResult)GsonUtil.fromJson(message, ChatroomUserQueryResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroom.getId(), UTF8));
        sb.append("&count=").append(URLEncoder.encode(chatroom.getCount().toString(), UTF8));
        sb.append("&order=").append(URLEncoder.encode(chatroom.getOrder().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ChatroomUserQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ChatroomUserQueryResult.class);
    }

    public CheckChatRoomUsersResult isExists(ChatroomModel chatroomModel) throws Exception {
        ChatroomMember[] members;
        String message = CommonUtil.checkFiled(chatroomModel, PATH, "isExists");
        if (null != message) {
            return (CheckChatRoomUsersResult)GsonUtil.fromJson(message, CheckChatRoomUsersResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&chatroomId=").append(URLEncoder.encode(chatroomModel.getId(), UTF8));
        for (ChatroomMember member : members = chatroomModel.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/users/exist.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (CheckChatRoomUsersResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "isExists", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), CheckChatRoomUsersResult.class);
    }

    public CheckChatRoomUserResult isExist(ChatroomMember member) throws Exception {
        String message = CommonUtil.checkFiled(member, PATH, "isExist");
        if (null != message) {
            return (CheckChatRoomUserResult)GsonUtil.fromJson(message, CheckChatRoomUserResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("chatroomId=").append(URLEncoder.encode(member.chatroomId, UTF8));
        sb.append("&userId=").append(URLEncoder.encode(member.id, UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/user/exist.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (CheckChatRoomUserResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "isExist", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), CheckChatRoomUserResult.class);
    }

    public ChatroomQueryResult query(ChatroomModel chatroomModel) throws Exception {
        String message = CommonUtil.checkFiled(chatroomModel, PATH, "query");
        if (null != message) {
            return (ChatroomQueryResult)GsonUtil.fromJson(message, ChatroomQueryResult.class);
        }
        String body = "chatroomId=" + URLEncoder.encode(chatroomModel.getId(), UTF8);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/chatroom/get.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ChatroomQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "query", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ChatroomQueryResult.class);
    }
}

