/*
 * Decompiled with CFR 0.152.
 */
package io.rong;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RongCloudConfig {
    public static RongCloudConfig DefaultConfig = new RongCloudConfig();
    public static RongCloudConfig SingaporeConfig = new RongCloudConfig("http://api.sg-light-api.com");
    public String[] apiDomains = new String[]{"http://api.rong-api.com", "http://api-b.rong-api.com"};
    public int errorSwitchingThreshold = 1;
    public int httpConnectTimeout = 30000;
    public int httpReadTimeout = 30000;
    public AtomicInteger errorCounter = new AtomicInteger(0);
    private AtomicInteger index = new AtomicInteger(0);

    public RongCloudConfig() {
    }

    public RongCloudConfig(String apiDomain) {
        if (apiDomain != null) {
            this.apiDomains = new String[]{apiDomain};
        }
    }

    public RongCloudConfig(String[] apiDomains) {
        this.apiDomains = apiDomains;
    }

    public RongCloudConfig(List<String> apiDomainList) {
        if (apiDomainList != null && apiDomainList.size() > 0) {
            this.apiDomains = apiDomainList.toArray(new String[0]);
        }
    }

    public String getDomain() {
        try {
            if (this.errorCounter.get() >= this.errorSwitchingThreshold) {
                this.errorCounter.set(0);
                this.index.incrementAndGet();
            }
            return this.apiDomains[Math.abs(this.index.get()) % this.apiDomains.length];
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get Server API Domain.", e);
        }
    }
}

