/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.audience;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.audience.AudienceType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AudienceTarget
implements PushModel {
    private final AudienceType audienceType;
    private final Set<String> values;

    private AudienceTarget(AudienceType audienceType, Set<String> values) {
        this.audienceType = audienceType;
        this.values = values;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AudienceTarget tag(String ... tag) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG).addAudienceTargetValues(tag).build();
    }

    public static AudienceTarget tag(Collection<String> tags) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG).addAudienceTargetValues(tags).build();
    }

    public static AudienceTarget tag_and(String ... tag) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_AND).addAudienceTargetValues(tag).build();
    }

    public static AudienceTarget tag_and(Collection<String> tags) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_AND).addAudienceTargetValues(tags).build();
    }

    public static AudienceTarget tag_not(String ... tag) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_NOT).addAudienceTargetValues(tag).build();
    }

    public static AudienceTarget tag_not(Collection<String> tags) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_NOT).addAudienceTargetValues(tags).build();
    }

    public static AudienceTarget alias(String ... alias) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.ALIAS).addAudienceTargetValues(alias).build();
    }

    public static AudienceTarget alias(Collection<String> aliases) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.ALIAS).addAudienceTargetValues(aliases).build();
    }

    public static AudienceTarget registrationId(String ... registrationId) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.REGISTRATION_ID).addAudienceTargetValues(registrationId).build();
    }

    public static AudienceTarget registrationId(Collection<String> registrationIds) {
        return AudienceTarget.newBuilder().setAudienceType(AudienceType.REGISTRATION_ID).addAudienceTargetValues(registrationIds).build();
    }

    public AudienceType getAudienceType() {
        return this.audienceType;
    }

    public String getAudienceTypeValue() {
        return this.audienceType.value();
    }

    @Override
    public JsonElement toJSON() {
        JsonArray array = new JsonArray();
        if (null != this.values) {
            for (String value : this.values) {
                array.add((JsonElement)new JsonPrimitive(value));
            }
        }
        return array;
    }

    public static class Builder {
        private AudienceType audienceType = null;
        private Set<String> valueBuilder = null;

        public Builder setAudienceType(AudienceType audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        public Builder addAudienceTargetValue(String value) {
            if (null == this.valueBuilder) {
                this.valueBuilder = new HashSet<String>();
            }
            this.valueBuilder.add(value);
            return this;
        }

        public Builder addAudienceTargetValues(Collection<String> values) {
            if (null == this.valueBuilder) {
                this.valueBuilder = new HashSet<String>();
            }
            for (String value : values) {
                this.valueBuilder.add(value);
            }
            return this;
        }

        public Builder addAudienceTargetValues(String ... values) {
            if (null == this.valueBuilder) {
                this.valueBuilder = new HashSet<String>();
            }
            for (String value : values) {
                this.valueBuilder.add(value);
            }
            return this;
        }

        public AudienceTarget build() {
            Preconditions.checkArgument((null != this.audienceType ? 1 : 0) != 0, (Object)"AudienceType should be set.");
            Preconditions.checkArgument((null != this.valueBuilder ? 1 : 0) != 0, (Object)"Target values should be set one at least.");
            return new AudienceTarget(this.audienceType, this.valueBuilder);
        }
    }
}

