/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.tenant;

import cn.herodotus.engine.assistant.core.context.TenantContextHolder;
import cn.herodotus.engine.rest.core.utils.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class MultiTenantInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MultiTenantInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getRequestURI();
        log.debug("[Herodotus] |- Current REQUEST is : [{}].", (Object)path);
        String tenantId = request.getHeader("X-Herodotus-Tenant-Id");
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = "public";
        }
        log.debug("[Herodotus] |- Current TENANT ID is : [{}].", (Object)tenantId);
        TenantContextHolder.setTenantId((String)tenantId);
        String sessionId = WebUtils.getSessionId((HttpServletRequest)request);
        String herodotusSessionId = request.getHeader("X-Herodotus-Session");
        log.debug("[Herodotus] |- SESSION ID is : [{}].", (Object)sessionId);
        log.debug("[Herodotus] |- SESSION ID of Herodotus custom is : [{}].", (Object)herodotusSessionId);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String path = request.getRequestURI();
        TenantContextHolder.clear();
        log.debug("[Herodotus] |- Tenant Interceptor CLEAR tenantId for request [{}].", (Object)path);
    }
}

