/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.secure.interceptor;

import cn.herodotus.engine.rest.protect.secure.interceptor.XssHttpServletRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XssHttpServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper(request);
        log.trace("[Herodotus] |- XssHttpServletFilter wrapper request for [{}].", (Object)request.getRequestURI());
        filterChain.doFilter((ServletRequest)xssRequest, servletResponse);
    }
}

