/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.crypto.enhance;

import cn.herodotus.engine.rest.core.annotation.Crypto;
import cn.herodotus.engine.rest.core.exception.SessionInvalidException;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartRequest;

public class DecryptRequestParamResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestParamResolver.class);
    private HttpCryptoProcessor httpCryptoProcessor;
    private RequestParamMethodArgumentResolver requestParamMethodArgumentResolver;

    public void setRequestParamMethodArgumentResolver(RequestParamMethodArgumentResolver requestParamMethodArgumentResolver) {
        this.requestParamMethodArgumentResolver = requestParamMethodArgumentResolver;
    }

    public void setInterfaceCryptoProcessor(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        String methodName = methodParameter.getMethod().getName();
        boolean isSupports = this.isConfigCrypto(methodParameter) && this.requestParamMethodArgumentResolver.supportsParameter(methodParameter);
        log.trace("[Herodotus] |- Is DecryptRequestParamResolver supports method [{}] ? Status is [{}].", (Object)methodName, (Object)isSupports);
        return isSupports;
    }

    private boolean isConfigCrypto(MethodParameter methodParameter) {
        Crypto crypto = (Crypto)methodParameter.getMethodAnnotation(Crypto.class);
        return ObjectUtils.isNotEmpty((Object)crypto) && crypto.requestDecrypt();
    }

    private boolean isRegularRequest(NativeWebRequest webRequest) {
        MultipartRequest multipartRequest = (MultipartRequest)webRequest.getNativeRequest(MultipartRequest.class);
        return ObjectUtils.isEmpty((Object)multipartRequest);
    }

    private String[] decrypt(String sessionId, String[] paramValues) throws SessionInvalidException {
        ArrayList<String> values = new ArrayList<String>();
        for (String paramValue : paramValues) {
            String value = this.httpCryptoProcessor.decrypt(sessionId, paramValue);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            values.add(value);
        }
        String[] result = new String[values.size()];
        return values.toArray(result);
    }

    @Nullable
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (this.isRegularRequest(webRequest)) {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            String sessionId = request.getHeader("X-Herodotus-Session");
            if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                Object[] paramValues = request.getParameterValues(methodParameter.getParameterName());
                if (ArrayUtils.isNotEmpty((Object[])paramValues)) {
                    String[] values = this.decrypt(sessionId, (String[])paramValues);
                    return values.length == 1 ? values[0] : values;
                }
            } else {
                log.warn("[Herodotus] |- Cannot find Herodotus Cloud custom session header. Use interface crypto founction need add X_HERODOTUS_SESSION to request header.");
            }
        }
        log.debug("[Herodotus] |- The decryption conditions are not met DecryptRequestParamResolver, skip! to next!");
        return this.requestParamMethodArgumentResolver.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
    }
}

