/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.rest.protect.crypto.enhance;

import cn.herodotus.engine.rest.core.annotation.Crypto;
import cn.herodotus.engine.rest.protect.crypto.processor.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;

public class DecryptRequestParamMapResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestParamMapResolver.class);
    private HttpCryptoProcessor httpCryptoProcessor;
    private RequestParamMapMethodArgumentResolver requestParamMapMethodArgumentResolver;

    public void setInterfaceCryptoProcessor(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    public void setRequestParamMapMethodArgumentResolver(RequestParamMapMethodArgumentResolver requestParamMapMethodArgumentResolver) {
        this.requestParamMapMethodArgumentResolver = requestParamMapMethodArgumentResolver;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        String methodName = methodParameter.getMethod().getName();
        boolean isSupports = this.requestParamMapMethodArgumentResolver.supportsParameter(methodParameter);
        log.trace("[Herodotus] |- Is DecryptRequestParamMapResolver supports method [{}] ? Status is [{}].", (Object)methodName, (Object)isSupports);
        return isSupports;
    }

    private boolean isConfigCrypto(MethodParameter methodParameter) {
        Crypto crypto = (Crypto)methodParameter.getMethodAnnotation(Crypto.class);
        return ObjectUtils.isNotEmpty((Object)crypto) && crypto.requestDecrypt();
    }

    private boolean isOauthTokenRequest(String uri, String method) {
        return StringUtils.equals((CharSequence)uri, (CharSequence)"/oauth2/token") && StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)HttpMethod.POST.name());
    }

    private boolean isRegularMap(MethodParameter methodParameter) {
        if (!MultiValueMap.class.isAssignableFrom(methodParameter.getParameterType())) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
            Class valueType = resolvableType.asMap().getGeneric(new int[]{1}).resolve();
            return valueType != MultipartFile.class && valueType != Part.class;
        }
        return false;
    }

    @Nullable
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String requestURI = request.getRequestURI();
        String requestMethod = request.getMethod();
        String sessionId = request.getHeader("X-Herodotus-Session");
        if (this.isConfigCrypto(methodParameter) || this.isOauthTokenRequest(requestURI, requestMethod)) {
            if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                if (this.isRegularMap(methodParameter)) {
                    Map parameterMap = webRequest.getParameterMap();
                    LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)parameterMap.size());
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String[] values = (String[])entry.getValue();
                        if (values.length <= 0) continue;
                        String value = this.httpCryptoProcessor.decrypt(sessionId, values[0]);
                        result.put(key, value);
                    }
                    return result;
                }
            } else {
                log.warn("[Herodotus] |- Cannot find Herodotus Cloud custom session header. Use interface crypto founction need add X_HERODOTUS_SESSION to request header.");
            }
        }
        log.debug("[Herodotus] |- The decryption conditions are not met DecryptRequestParamMapResolver, skip! to next!");
        return this.requestParamMapMethodArgumentResolver.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
    }
}

