/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.kpswitch.util;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;
import cn.dreamtobe.kpswitch.util.KeyboardUtil;
import cn.dreamtobe.kpswitch.util.ViewUtil;

public class KPSwitchConflictUtil {
    public static void attach(View panelLayout, View switchPanelKeyboardBtn, View focusView) {
        KPSwitchConflictUtil.attach(panelLayout, switchPanelKeyboardBtn, focusView, null);
    }

    public static void attach(final View panelLayout, View switchPanelKeyboardBtn, final View focusView, final SwitchClickListener switchClickListener) {
        Activity activity = (Activity)panelLayout.getContext();
        if (switchPanelKeyboardBtn != null) {
            switchPanelKeyboardBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    boolean switchToPanel = KPSwitchConflictUtil.switchPanelAndKeyboard(panelLayout, focusView);
                    if (switchClickListener != null) {
                        switchClickListener.onClickSwitch(switchToPanel);
                    }
                }
            });
        }
        if (KPSwitchConflictUtil.isHandleByPlaceholder(activity)) {
            focusView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 1) {
                        panelLayout.setVisibility(4);
                    }
                    return false;
                }
            });
        }
    }

    public static void attach(View panelLayout, View focusView, SubPanelAndTrigger ... subPanelAndTriggers) {
        KPSwitchConflictUtil.attach(panelLayout, focusView, null, subPanelAndTriggers);
    }

    public static void attach(final View panelLayout, View focusView, SwitchClickListener switchClickListener, SubPanelAndTrigger ... subPanelAndTriggers) {
        Activity activity = (Activity)panelLayout.getContext();
        for (SubPanelAndTrigger subPanelAndTrigger : subPanelAndTriggers) {
            KPSwitchConflictUtil.bindSubPanel(subPanelAndTrigger, subPanelAndTriggers, focusView, panelLayout, switchClickListener);
        }
        if (KPSwitchConflictUtil.isHandleByPlaceholder(activity)) {
            focusView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (event.getAction() == 1) {
                        panelLayout.setVisibility(4);
                    }
                    return false;
                }
            });
        }
    }

    public static void showPanel(View panelLayout) {
        Activity activity = (Activity)panelLayout.getContext();
        panelLayout.setVisibility(0);
        if (activity.getCurrentFocus() != null) {
            KeyboardUtil.hideKeyboard(activity.getCurrentFocus());
        }
    }

    public static void showKeyboard(View panelLayout, View focusView) {
        Activity activity = (Activity)panelLayout.getContext();
        KeyboardUtil.showKeyboard(focusView);
        if (KPSwitchConflictUtil.isHandleByPlaceholder(activity)) {
            panelLayout.setVisibility(4);
        }
    }

    public static boolean switchPanelAndKeyboard(View panelLayout, View focusView) {
        boolean switchToPanel;
        boolean bl = switchToPanel = panelLayout.getVisibility() != 0;
        if (!switchToPanel) {
            KPSwitchConflictUtil.showKeyboard(panelLayout, focusView);
        } else {
            KPSwitchConflictUtil.showPanel(panelLayout);
        }
        return switchToPanel;
    }

    public static void hidePanelAndKeyboard(View panelLayout) {
        Activity activity = (Activity)panelLayout.getContext();
        View focusView = activity.getCurrentFocus();
        if (focusView != null) {
            KeyboardUtil.hideKeyboard(activity.getCurrentFocus());
            focusView.clearFocus();
        }
        panelLayout.setVisibility(8);
    }

    public static boolean isHandleByPlaceholder(boolean isFullScreen, boolean isTranslucentStatus, boolean isFitsSystem) {
        return isFullScreen || isTranslucentStatus && !isFitsSystem;
    }

    static boolean isHandleByPlaceholder(Activity activity) {
        return KPSwitchConflictUtil.isHandleByPlaceholder(ViewUtil.isFullScreen(activity), ViewUtil.isTranslucentStatus(activity), ViewUtil.isFitsSystemWindows(activity));
    }

    private static void bindSubPanel(SubPanelAndTrigger subPanelAndTrigger, final SubPanelAndTrigger[] subPanelAndTriggers, final View focusView, final View panelLayout, final SwitchClickListener switchClickListener) {
        View triggerView = subPanelAndTrigger.triggerView;
        final View boundTriggerSubPanelView = subPanelAndTrigger.subPanelView;
        triggerView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Boolean switchToPanel = null;
                if (panelLayout.getVisibility() == 0) {
                    if (boundTriggerSubPanelView.getVisibility() == 0) {
                        KPSwitchConflictUtil.showKeyboard(panelLayout, focusView);
                        switchToPanel = false;
                    } else {
                        KPSwitchConflictUtil.showBoundTriggerSubPanel(boundTriggerSubPanelView, subPanelAndTriggers);
                    }
                } else {
                    KPSwitchConflictUtil.showPanel(panelLayout);
                    switchToPanel = true;
                    KPSwitchConflictUtil.showBoundTriggerSubPanel(boundTriggerSubPanelView, subPanelAndTriggers);
                }
                if (switchClickListener != null && switchToPanel != null) {
                    switchClickListener.onClickSwitch(switchToPanel);
                }
            }
        });
    }

    private static void showBoundTriggerSubPanel(View boundTriggerSubPanelView, SubPanelAndTrigger[] subPanelAndTriggers) {
        for (SubPanelAndTrigger panelAndTrigger : subPanelAndTriggers) {
            if (panelAndTrigger.subPanelView == boundTriggerSubPanelView) continue;
            panelAndTrigger.subPanelView.setVisibility(8);
        }
        boundTriggerSubPanelView.setVisibility(0);
    }

    public static interface SwitchClickListener {
        public void onClickSwitch(boolean var1);
    }

    public static class SubPanelAndTrigger {
        final View subPanelView;
        final View triggerView;

        public SubPanelAndTrigger(View subPanelView, View triggerView) {
            this.subPanelView = subPanelView;
            this.triggerView = triggerView;
        }
    }
}

