/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.spring.plugins.secondary;

import cloud.tianai.captcha.spring.application.FilterImageCaptchaApplication;
import cloud.tianai.captcha.spring.application.ImageCaptchaApplication;
import cloud.tianai.captcha.spring.autoconfiguration.SecondaryVerificationProperties;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SecondaryVerificationApplication
extends FilterImageCaptchaApplication {
    private SecondaryVerificationProperties prop;

    public SecondaryVerificationApplication(ImageCaptchaApplication target, SecondaryVerificationProperties prop) {
        super(target);
        this.prop = prop;
    }

    @Override
    public boolean matching(String id, ImageCaptchaTrack imageCaptchaTrack) {
        boolean match = super.matching(id, imageCaptchaTrack);
        if (match) {
            this.addSecondaryVerification(id, imageCaptchaTrack);
        }
        return match;
    }

    public boolean secondaryVerification(String id) {
        Map<String, Object> cache = this.target.getCacheStore().getAndRemoveCache(this.getKey(id));
        return cache != null;
    }

    protected void addSecondaryVerification(String id, ImageCaptchaTrack imageCaptchaTrack) {
        this.target.getCacheStore().setCache(this.getKey(id), Collections.emptyMap(), this.prop.getExpire(), TimeUnit.MILLISECONDS);
    }

    protected String getKey(String id) {
        return this.prop.getKeyPrefix().concat(":").concat(id);
    }
}

