/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser;

import ch.randelshofer.fastdoubleparser.FastDoubleMath;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class FastDoubleParserFromByteArray {
    private static final long MINIMAL_NINETEEN_DIGIT_INTEGER = 1000000000000000000L;
    private static final int MINIMAL_EIGHT_DIGIT_INTEGER = 10000000;
    private static final byte DECIMAL_POINT_CLASS = -4;
    private static final byte OTHER_CLASS = -1;
    private static final byte[] CHAR_TO_HEX_MAP;
    private static final VarHandle readLongFromByteArray;

    private FastDoubleParserFromByteArray() {
    }

    private static boolean isInteger(byte c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isMadeOfEightDigits(long val) {
        long l = (val + 0x4646464646464646L | val - 0x3030303030303030L) & 0x8080808080808080L;
        return l == 0L;
    }

    private static NumberFormatException newNumberFormatException(byte[] str, int off, int len) {
        if (len > 1024) {
            return new NumberFormatException("For input string of length " + len);
        }
        return new NumberFormatException("For input string: \"" + new String(str, off, len, StandardCharsets.ISO_8859_1) + "\"");
    }

    public static double parseDouble(byte[] str) throws NumberFormatException {
        return FastDoubleParserFromByteArray.parseDouble(str, 0, str.length);
    }

    public static double parseDouble(byte[] str, int off, int len) throws NumberFormatException {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = len + off;
        int index = FastDoubleParserFromByteArray.skipWhitespace(str, off, endIndex);
        if (index == endIndex) {
            throw new NumberFormatException("empty String");
        }
        byte ch = str[index];
        boolean bl = isNegative = ch == 45;
        if (isNegative || ch == 43) {
            byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            if (ch == 0) {
                throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, len);
            }
        }
        if (ch == 78) {
            return FastDoubleParserFromByteArray.parseNaN(str, index, endIndex, off);
        }
        if (ch == 73) {
            return FastDoubleParserFromByteArray.parseInfinity(str, index, endIndex, isNegative, off);
        }
        boolean bl2 = hasLeadingZero = ch == 48;
        if (hasLeadingZero) {
            byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            if (ch == 120 || ch == 88) {
                return FastDoubleParserFromByteArray.parseRestOfHexFloatingPointLiteral(str, index + 1, endIndex, isNegative, off);
            }
        }
        return FastDoubleParserFromByteArray.parseRestOfDecimalFloatLiteral(str, endIndex, index, isNegative, hasLeadingZero, off);
    }

    private static int parseEightDigits(long val) {
        long mask = 0xFF000000FFL;
        long mul1 = 4294967296000100L;
        long mul2 = 42949672960001L;
        val -= 0x3030303030303030L;
        val = val * 10L + (val >>> 8);
        val = (val & mask) * mul1 + (val >>> 16 & mask) * mul2 >>> 32;
        return (int)val;
    }

    private static double parseInfinity(byte[] str, int index, int endIndex, boolean negative, int off) {
        if (index + 7 < endIndex && str[index + 1] == 110 && str[index + 2] == 102 && str[index + 3] == 105 && str[index + 4] == 110 && str[index + 5] == 105 && str[index + 6] == 116 && str[index + 7] == 121) {
            if ((index = FastDoubleParserFromByteArray.skipWhitespace(str, index + 8, endIndex)) < endIndex) {
                throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
            }
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
    }

    private static double parseNaN(byte[] str, int index, int endIndex, int off) {
        if (index + 2 < endIndex && str[index + 1] == 97 && str[index + 2] == 78) {
            if ((index = FastDoubleParserFromByteArray.skipWhitespace(str, index + 3, endIndex)) < endIndex) {
                throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
            }
            return Double.NaN;
        }
        throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
    }

    private static double parseRestOfDecimalFloatLiteral(byte[] str, int endIndex, int index, boolean isNegative, boolean hasLeadingZero, int off) {
        boolean isDigitsTruncated;
        boolean hasExponent;
        int digitCount;
        byte ch = index < endIndex ? str[index] : (byte)0;
        long digits = 0L;
        long exponent = 0L;
        int indexOfFirstDigit = index;
        int virtualIndexOfPoint = -1;
        while (index < endIndex) {
            ch = str[index];
            if (FastDoubleParserFromByteArray.isInteger(ch)) {
                digits = 10L * digits + (long)ch - 48L;
            } else {
                long val;
                if (ch != 46) break;
                if (virtualIndexOfPoint != -1) {
                    throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
                }
                virtualIndexOfPoint = index;
                while (index < endIndex - 9 && FastDoubleParserFromByteArray.isMadeOfEightDigits(val = readLongFromByteArray.get(str, index + 1))) {
                    digits = digits * 100000000L + (long)FastDoubleParserFromByteArray.parseEightDigits(val);
                    index += 8;
                }
            }
            ++index;
        }
        int indexAfterDigits = index;
        if (virtualIndexOfPoint == -1) {
            digitCount = indexAfterDigits - indexOfFirstDigit;
            virtualIndexOfPoint = indexAfterDigits;
        } else {
            digitCount = indexAfterDigits - indexOfFirstDigit - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        long exp_number = 0L;
        boolean bl = hasExponent = ch == 101 || ch == 69;
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (byte)0;
            boolean bl2 = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            }
            if (!FastDoubleParserFromByteArray.isInteger(ch)) {
                throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
            }
            while (FastDoubleParserFromByteArray.isInteger(ch)) {
                if (exp_number < 10000000L) {
                    exp_number = 10L * exp_number + (long)ch - 48L;
                }
                ch = ++index < endIndex ? str[index] : (byte)0;
            }
            if (neg_exp) {
                exp_number = -exp_number;
            }
            exponent += exp_number;
        }
        if ((index = FastDoubleParserFromByteArray.skipWhitespace(str, index, endIndex)) < endIndex || !hasLeadingZero && digitCount == 0 && str[virtualIndexOfPoint] != 46) {
            throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            digits = 0L;
            for (index = indexOfFirstDigit; index < indexAfterDigits; ++index) {
                ch = str[index];
                if (ch == 46) {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(digits, 1000000000000000000L) >= 0) break;
                digits = 10L * digits + (long)ch - 48L;
            }
            isDigitsTruncated = index < indexAfterDigits;
        } else {
            isDigitsTruncated = false;
        }
        Double result = FastDoubleMath.decFloatLiteralToDouble(index, isNegative, digits, exponent, virtualIndexOfPoint, exp_number, isDigitsTruncated, skipCountInTruncatedDigits);
        if (result == null) {
            return FastDoubleParserFromByteArray.parseRestOfDecimalFloatLiteralTheHardWay(str, off, endIndex - off);
        }
        return result;
    }

    private static double parseRestOfDecimalFloatLiteralTheHardWay(byte[] str, int off, int len) {
        return Double.parseDouble(new String(str, off, len, StandardCharsets.ISO_8859_1));
    }

    private static double parseRestOfHexFloatingPointLiteral(byte[] str, int index, int endIndex, boolean isNegative, int off) {
        boolean isDigitsTruncated;
        boolean hasExponent;
        int digitCount;
        if (index >= endIndex) {
            throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
        }
        byte ch = str[index];
        long digits = 0L;
        long exponent = 0L;
        int indexOfFirstDigit = index;
        int virtualIndexOfPoint = -1;
        while (index < endIndex) {
            int hexValue;
            ch = str[index];
            int n = hexValue = ch < 0 ? -1 : CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                digits = digits << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                if (virtualIndexOfPoint != -1) {
                    throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
                }
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int indexAfterDigits = index;
        if (virtualIndexOfPoint == -1) {
            digitCount = indexAfterDigits - indexOfFirstDigit;
            virtualIndexOfPoint = indexAfterDigits;
        } else {
            digitCount = indexAfterDigits - indexOfFirstDigit - 1;
            exponent = (long)(virtualIndexOfPoint - index + 1) * 4L;
        }
        long exp_number = 0L;
        boolean bl = hasExponent = ch == 112 || ch == 80;
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? str[index] : (byte)0;
            boolean bl2 = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                byte by = ch = ++index < endIndex ? str[index] : (byte)0;
            }
            if (!FastDoubleParserFromByteArray.isInteger(ch)) {
                throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
            }
            while (FastDoubleParserFromByteArray.isInteger(ch)) {
                if (exp_number < 10000000L) {
                    exp_number = 10L * exp_number + (long)ch - 48L;
                }
                ch = ++index < endIndex ? str[index] : (byte)0;
            }
            if (neg_exp) {
                exp_number = -exp_number;
            }
            exponent += exp_number;
        }
        if ((index = FastDoubleParserFromByteArray.skipWhitespace(str, index, endIndex)) < endIndex || digitCount == 0 && str[virtualIndexOfPoint] != 46 || !hasExponent) {
            throw FastDoubleParserFromByteArray.newNumberFormatException(str, off, endIndex - off);
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            digits = 0L;
            for (index = indexOfFirstDigit; index < indexAfterDigits; ++index) {
                int hexValue;
                ch = str[index];
                int n = hexValue = ch < 0 ? -1 : CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(digits, 1000000000000000000L) >= 0) break;
                    digits = digits << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isDigitsTruncated = index < indexAfterDigits;
        } else {
            isDigitsTruncated = false;
        }
        Double d = FastDoubleMath.hexFloatLiteralToDouble(index, isNegative, digits, exponent, virtualIndexOfPoint, exp_number, isDigitsTruncated, skipCountInTruncatedDigits);
        return d == null ? Double.parseDouble(new String(str, off, endIndex - off)) : d;
    }

    private static int skipWhitespace(byte[] str, int index, int endIndex) {
        while (index < endIndex && (str[index] & 0xFF) <= 32) {
            ++index;
        }
        return index;
    }

    static {
        int ch;
        CHAR_TO_HEX_MAP = new byte[256];
        readLongFromByteArray = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        for (ch = 0; ch < CHAR_TO_HEX_MAP.length; ch = (int)((char)(ch + 1))) {
            FastDoubleParserFromByteArray.CHAR_TO_HEX_MAP[ch] = -1;
        }
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            FastDoubleParserFromByteArray.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 48);
        }
        for (ch = 65; ch <= 70; ch = (int)((char)(ch + 1))) {
            FastDoubleParserFromByteArray.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 65 + 10);
        }
        for (ch = 97; ch <= 102; ch = (int)((char)(ch + 1))) {
            FastDoubleParserFromByteArray.CHAR_TO_HEX_MAP[ch] = (byte)(ch - 97 + 10);
        }
        for (ch = 46; ch <= 46; ch = (int)((char)(ch + 1))) {
            FastDoubleParserFromByteArray.CHAR_TO_HEX_MAP[ch] = -4;
        }
    }
}

