package ch.fortysix.maven.report.taglist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-postman-plugin.<br/> Call <pre>  mvn postman:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat Jan 30 18:59:53 CET 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "ch.fortysix:maven-postman-plugin:0.1.0", 0 );
        append( sb, "", 0 );

        append( sb, "Postman mail plugin", 0 );
        append( sb, "Enables conditional sending of mails in a build. The purpose of the plugin is to support conditional emailing (e.g. send an email if a file contains a certain string or there like)", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "postman:help", 0 );
            append( sb, "Display help information on maven-postman-plugin.\nCall\n\u00a0\u00a0mvn\u00a0postman:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "postman-criterion-report".equals( goal ) )
        {
            append( sb, "postman:postman-criterion-report", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "docuSite (Default: http://localhost/${artifactId}/)", 2 );
                append( sb, "The url where to find the deployed documentation. This is used to create a link to reports from within mails.", 3 );
                append( sb, "", 0 );

                append( sb, "failonerror (Default: true)", 2 );
                append( sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "filesets", 2 );
                append( sb, "A list of fileSets to select the files to be analyzed.", 3 );
                append( sb, "", 0 );

                append( sb, "from", 2 );
                append( sb, "Email address of sender.", 3 );
                append( sb, "", 0 );

                append( sb, "mailAltConfig (Default: false)", 2 );
                append( sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3 );
                append( sb, "", 0 );

                append( sb, "mailcontenttype (Default: text/html)", 2 );
                append( sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support \'multipart/alternative\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mailhost (Default: localhost)", 2 );
                append( sb, "Host name of the SMTP server. The default value is localhost.", 3 );
                append( sb, "", 0 );

                append( sb, "mailpassword", 2 );
                append( sb, "Password for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "mailport (Default: 25)", 2 );
                append( sb, "TCP port of the SMTP server. The default value is 25.", 3 );
                append( sb, "", 0 );

                append( sb, "mailssl (Default: false)", 2 );
                append( sb, "Indicates whether you need TLS/SSL", 3 );
                append( sb, "", 0 );

                append( sb, "mailuser", 2 );
                append( sb, "User name for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "multipartSupported (Default: true)", 2 );
                append( sb, "Whether \'multipart/alternative\' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of \'mailcontenttype\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "reportFile (Default: ${project.build.directory}/postman.xml)", 2 );
                append( sb, "The xml file to read/write the postman report from/to.", 3 );
                append( sb, "", 0 );

                append( sb, "rules", 2 );
                append( sb, "A list of rule elements defining when and where to send a message. You might use the id of developer in the pom or an email directly.\n<rules>\n<rule>\n<regex>.*(author).*</regex>\n<receivers>\n<receiver>developerId</receiver>\n<receiver>sam@yy.com</receiver>\n</receivers>\n</rule>\n</rules>\n", 3 );
                append( sb, "", 0 );

                append( sb, "skipMails (Default: false)", 2 );
                append( sb, "Indicates whether this report should skip the sending mails (no mails send).", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3 );
                append( sb, "", 0 );

                append( sb, "subject (Default: ${artifactId}: )", 2 );
                append( sb, "Email subject line.", 3 );
                append( sb, "", 0 );

                append( sb, "subjectPostFix (Default: criterion reminder)", 2 );
                append( sb, "The postfix used in the email subject", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "postman-surefire-report".equals( goal ) )
        {
            append( sb, "postman:postman-surefire-report", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "docuSite (Default: http://localhost/${artifactId}/)", 2 );
                append( sb, "The url where to find the deployed documentation. This is used to create a link to reports from within mails.", 3 );
                append( sb, "", 0 );

                append( sb, "failonerror (Default: true)", 2 );
                append( sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "from", 2 );
                append( sb, "Email address of sender.", 3 );
                append( sb, "", 0 );

                append( sb, "groovyCondition (Default: errors > 0 || failures > 0)", 2 );
                append( sb, "This allows to redefine the condition to send the mail. e.g. one can define that there must not be more then 20 skipped test cases (skipped > 20. The default condition sends mails if there are any errors. The following variables are available for usage in the condition:\n-\terrors: number of all errors while running surefire\n-\tskipped: number of all skipped test cases\n-\tfailures: number of all failures in the test cases\n-\ttotal: number of all test cases\nOther (usefull or not...) examples:\n-\terrors > 0 : sends a mail only if there are errors\n-\tskipped > failures : sends mails if there are more skipped then failed test cases\n-\ttotal == skipped : Sends mails if all tests are skipped\nTo avoid problems with XML syntax, one can use a CDATA element. The default only send a mail if there are errors or failures, but ignores the skipped ones.", 3 );
                append( sb, "", 0 );

                append( sb, "mailAltConfig (Default: false)", 2 );
                append( sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3 );
                append( sb, "", 0 );

                append( sb, "mailcontenttype (Default: text/html)", 2 );
                append( sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support \'multipart/alternative\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mailhost (Default: localhost)", 2 );
                append( sb, "Host name of the SMTP server. The default value is localhost.", 3 );
                append( sb, "", 0 );

                append( sb, "mailpassword", 2 );
                append( sb, "Password for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "mailport (Default: 25)", 2 );
                append( sb, "TCP port of the SMTP server. The default value is 25.", 3 );
                append( sb, "", 0 );

                append( sb, "mailssl (Default: false)", 2 );
                append( sb, "Indicates whether you need TLS/SSL", 3 );
                append( sb, "", 0 );

                append( sb, "mailuser", 2 );
                append( sb, "User name for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "multipartSupported (Default: true)", 2 );
                append( sb, "Whether \'multipart/alternative\' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of \'mailcontenttype\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "receivers", 2 );
                append( sb, "Who should receive a mail? One can use an id of a developer registered in the pom or an email address directly.\n<receivers>\n<receiver>developerId</receiver>\n<receiver>sam@topland.com</receiver>\n</receivers>\n", 3 );
                append( sb, "", 0 );

                append( sb, "reportFilePattern (Default: TEST-.*.xml)", 2 );
                append( sb, "The file pattern to be used to search for the surefire reports in the \'testReportsDirectory\'-directory.", 3 );
                append( sb, "", 0 );

                append( sb, "skipMails (Default: false)", 2 );
                append( sb, "Indicates whether this report should skip the sending mails (no mails send).", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3 );
                append( sb, "", 0 );

                append( sb, "subject (Default: ${artifactId}: )", 2 );
                append( sb, "Email subject line.", 3 );
                append( sb, "", 0 );

                append( sb, "subjectPostFix (Default: surfire tests reminder)", 2 );
                append( sb, "The postfix used in the email subject", 3 );
                append( sb, "", 0 );

                append( sb, "testReportsDirectory (Default: ${project.build.directory}/surefire-reports)", 2 );
                append( sb, "Base directory where all surefire test reports are read from.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "postman-taglist-report".equals( goal ) )
        {
            append( sb, "postman:postman-taglist-report", 0 );
            append( sb, "This plugin is able to send \'reminder mails\' based on the findings of the org.codehaus.mojo:taglist-maven-plugin. One should use at least version 2.4 of the taglist-plugin", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "docuSite (Default: http://localhost/${artifactId}/)", 2 );
                append( sb, "The url where to find the deployed documentation. This is used to create a link to reports from within mails.", 3 );
                append( sb, "", 0 );

                append( sb, "failonerror (Default: true)", 2 );
                append( sb, "flag to indicate whether to halt the build on any error. The default value is true.", 3 );
                append( sb, "", 0 );

                append( sb, "from", 2 );
                append( sb, "Email address of sender.", 3 );
                append( sb, "", 0 );

                append( sb, "mailAltConfig (Default: false)", 2 );
                append( sb, "Indicates to use an alternative way to configure the ssl connection to the smtp server. This might be needed in specific environments.", 3 );
                append( sb, "", 0 );

                append( sb, "mailcontenttype (Default: text/html)", 2 );
                append( sb, "The content type to use for the message. This is only the fallback contenttype if the environment does not support \'multipart/alternative\'.", 3 );
                append( sb, "", 0 );

                append( sb, "mailhost (Default: localhost)", 2 );
                append( sb, "Host name of the SMTP server. The default value is localhost.", 3 );
                append( sb, "", 0 );

                append( sb, "mailpassword", 2 );
                append( sb, "Password for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "mailport (Default: 25)", 2 );
                append( sb, "TCP port of the SMTP server. The default value is 25.", 3 );
                append( sb, "", 0 );

                append( sb, "mailssl (Default: false)", 2 );
                append( sb, "Indicates whether you need TLS/SSL", 3 );
                append( sb, "", 0 );

                append( sb, "mailuser", 2 );
                append( sb, "User name for SMTP auth", 3 );
                append( sb, "", 0 );

                append( sb, "multipartSupported (Default: true)", 2 );
                append( sb, "Whether \'multipart/alternative\' mails can be send. This is detected automatically, but it allows a user to disable it and force the usage of \'mailcontenttype\'.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Report output directory. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "skipMails (Default: false)", 2 );
                append( sb, "Indicates whether this report should skip the sending mails (no mails send).", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding of the source. Advice is taken from: POM Element for Source File Encoding", 3 );
                append( sb, "", 0 );

                append( sb, "subject (Default: ${artifactId}: )", 2 );
                append( sb, "Email subject line.", 3 );
                append( sb, "", 0 );

                append( sb, "subjectPostFix (Default: taglist reminder)", 2 );
                append( sb, "The postfix used in the email subject", 3 );
                append( sb, "", 0 );

                append( sb, "tagClasses", 2 );
                append( sb, "Maps the tag class (from taglist plugin) to a list of receivers. The displayName has to match the same from the taglist-maven-plugin configuration. Who should receive a mail? One can use an id of a developer registered in the pom or an email address directly.\n<tagClasses>\n<tagClass>\n<displayName>Todo\u00a0Work</displayName>\n<receivers>\n<receiver>developerId</receiver>\n<receiver>dude@xx.com</receiver>\n</receivers>\n</tagClass>\n</tagClasses>\n", 3 );
                append( sb, "", 0 );

                append( sb, "taglistReportHtml (Default: ${project.build.directory}/site/taglist.html)", 2 );
                append( sb, "The generated taglist html report (previously generated by \'taglist-maven-plugin\').", 3 );
                append( sb, "", 0 );

                append( sb, "taglistReportXml (Default: ${project.build.directory}/taglist/taglist.xml)", 2 );
                append( sb, "The generated taglist report (previously generated by \'taglist-maven-plugin\').", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
