/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import java.util.List;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ROR_ROR message structure (see chapter 4). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: MSA (Message Acknowledgment) <b> </b></li>
                 * <li>3: ERR (Error) <b>optional </b></li>
                 * <li>4: ROR_ROR_DEFINITION (a Group object) <b> repeating</b></li>
                 * <li>5: DSC (Continuation Pointer) <b>optional </b></li>
 * </ul>
 */
@SuppressWarnings("unused")
public class ROR_ROR extends AbstractMessage  {

    /**
     * Creates a new ROR_ROR message with DefaultModelClassFactory. 
     */ 
    public ROR_ROR() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ROR_ROR message with custom ModelClassFactory.
     */
    public ROR_ROR(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(ROR_ROR_DEFINITION.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating ROR_ROR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       return getTyped("MSH", MSH.class);
    }




    /**
     * Returns
     * MSA (Message Acknowledgment) - creates it if necessary
     */
    public MSA getMSA() { 
       return getTyped("MSA", MSA.class);
    }




    /**
     * Returns
     * ERR (Error) - creates it if necessary
     */
    public ERR getERR() { 
       return getTyped("ERR", ERR.class);
    }




    /**
     * Returns
     * the first repetition of 
     * DEFINITION (a Group object) - creates it if necessary
     */
    public ROR_ROR_DEFINITION getDEFINITION() { 
       return getTyped("DEFINITION", ROR_ROR_DEFINITION.class);
    }


    /**
     * Returns a specific repetition of
     * DEFINITION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ROR_ROR_DEFINITION getDEFINITION(int rep) { 
       return getTyped("DEFINITION", rep, ROR_ROR_DEFINITION.class);
    }

    /** 
     * Returns the number of existing repetitions of DEFINITION 
     */ 
    public int getDEFINITIONReps() { 
    	return getReps("DEFINITION");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of DEFINITION.
     * <p>
     * <p>
     * Note that unlike {@link #getDEFINITION()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public List<ROR_ROR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
    	return getAllAsList("DEFINITION", ROR_ROR_DEFINITION.class);
    } 

    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertDEFINITION(ROR_ROR_DEFINITION structure, int rep) throws HL7Exception { 
       super.insertRepetition( "DEFINITION", structure, rep);
    }


    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ROR_ROR_DEFINITION insertDEFINITION(int rep) throws HL7Exception { 
       return (ROR_ROR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }


    /**
     * Removes a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ROR_ROR_DEFINITION removeDEFINITION(int rep) throws HL7Exception { 
       return (ROR_ROR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }



    /**
     * Returns
     * DSC (Continuation Pointer) - creates it if necessary
     */
    public DSC getDSC() { 
       return getTyped("DSC", DSC.class);
    }




}

